/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.gui.menus;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.fibs.geotag.data.ImageInfo;
import org.fibs.geotag.gui.menus.MenuConstants;
import org.fibs.geotag.table.ImagesTable;
import org.fibs.geotag.table.ImagesTableModel;
import org.fibs.geotag.tasks.CopyLocationTask;
import org.fibs.geotag.tasks.TaskExecutor;

public class CopyLocationMenu
extends JMenu
implements MenuConstants,
ActionListener {
    private JMenuItem copyLocationToPreviousItem;
    private JMenuItem copyLocationToNextItem;
    private JMenuItem copyLocationToSelectedItem;
    private JMenuItem copyLocationToAllItem;
    private int[] selectedRows;
    private ImagesTableModel tableModel;
    private ImageInfo currentImage;

    public CopyLocationMenu(boolean backgroundTask, ImagesTable imagesTable, ImageInfo currentImage) {
        super(COPY_LOCATION);
        this.tableModel = (ImagesTableModel)imagesTable.getModel();
        this.currentImage = currentImage;
        int row = this.tableModel.getRow(currentImage);
        this.selectedRows = imagesTable.getSelectedRows();
        boolean menuEnabled = false;
        this.copyLocationToPreviousItem = new JMenuItem(COPY_LOCATION_PREVIOUS);
        boolean itemEnabled = !backgroundTask && currentImage.hasLocation() && row > 0;
        menuEnabled |= itemEnabled;
        this.copyLocationToPreviousItem.setEnabled(itemEnabled);
        this.copyLocationToPreviousItem.addActionListener(this);
        this.add(this.copyLocationToPreviousItem);
        this.copyLocationToNextItem = new JMenuItem(COPY_LOCATION_NEXT);
        itemEnabled = !backgroundTask && currentImage.hasLocation() && row < this.tableModel.getRowCount() - 1;
        menuEnabled |= itemEnabled;
        this.copyLocationToNextItem.setEnabled(itemEnabled);
        this.copyLocationToNextItem.addActionListener(this);
        this.add(this.copyLocationToNextItem);
        this.copyLocationToSelectedItem = new JMenuItem(COPY_LOCATION_SELECTED);
        itemEnabled = !backgroundTask && currentImage.hasLocation() && this.selectedRows.length > 0;
        menuEnabled |= itemEnabled;
        this.copyLocationToSelectedItem.setEnabled(itemEnabled);
        this.copyLocationToSelectedItem.addActionListener(this);
        this.add(this.copyLocationToSelectedItem);
        this.copyLocationToAllItem = new JMenuItem(COPY_LOCATION_ALL);
        itemEnabled = !backgroundTask && currentImage.hasLocation();
        menuEnabled |= itemEnabled;
        this.copyLocationToAllItem.setEnabled(itemEnabled);
        this.copyLocationToAllItem.addActionListener(this);
        this.add(this.copyLocationToAllItem);
    }

    private void copyLocationToPrevious() {
        int row = this.tableModel.getRow(this.currentImage);
        if (row > 0) {
            ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
            imageList.add(this.tableModel.getImageInfo(row - 1));
            TaskExecutor.execute(new CopyLocationTask(COPY_LOCATION, COPY_LOCATION_PREVIOUS, this.tableModel, this.currentImage, imageList));
        }
    }

    private void copyLocationToNext() {
        int row = this.tableModel.getRow(this.currentImage);
        if (row < this.tableModel.getRowCount() - 1) {
            ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
            imageList.add(this.tableModel.getImageInfo(row + 1));
            TaskExecutor.execute(new CopyLocationTask(COPY_LOCATION, COPY_LOCATION_NEXT, this.tableModel, this.currentImage, imageList));
        }
    }

    private void copyLocationToSelected() {
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        int index = 0;
        while (index < this.selectedRows.length) {
            imageList.add(this.tableModel.getImageInfo(this.selectedRows[index]));
            ++index;
        }
        TaskExecutor.execute(new CopyLocationTask(COPY_LOCATION, COPY_LOCATION_SELECTED, this.tableModel, this.currentImage, imageList));
    }

    private void copyLocationToAll() {
        ArrayList<ImageInfo> imageList = new ArrayList<ImageInfo>();
        int iindex = 0;
        while (iindex < this.tableModel.getRowCount()) {
            imageList.add(this.tableModel.getImageInfo(iindex));
            ++iindex;
        }
        TaskExecutor.execute(new CopyLocationTask(COPY_LOCATION, COPY_LOCATION_ALL, this.tableModel, this.currentImage, imageList));
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.copyLocationToPreviousItem) {
            this.copyLocationToPrevious();
        } else if (event.getSource() == this.copyLocationToNextItem) {
            this.copyLocationToNext();
        } else if (event.getSource() == this.copyLocationToSelectedItem) {
            this.copyLocationToSelected();
        } else if (event.getSource() == this.copyLocationToAllItem) {
            this.copyLocationToAll();
        }
    }
}

