/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.desktop.welcome;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.gephi.desktop.importer.api.ImportControllerUI;
import org.gephi.desktop.mrufiles.api.MostRecentFiles;
import org.gephi.project.api.Project;
import org.gephi.project.api.ProjectController;
import org.jdesktop.swingx.JXHeader;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.border.DropShadowBorder;
import org.openide.awt.Actions;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class WelcomeTopComponent
extends JPanel {
    public static final String STARTUP_PREF = "WelcomeScreen_Open_Startup";
    private static final Object LINK_PATH = new Object();
    private static WelcomeTopComponent instance;
    private Action openFileAction;
    private JXHeader header;
    private JLabel labelNew;
    private JLabel labelProjects;
    private JLabel labelRecent;
    private JLabel labelSamples;
    private JPanel mainPanel;
    private JXHyperlink newProjectLink;
    private JXHyperlink openFileLink;
    private JCheckBox openOnStartupCheckbox;
    private JPanel projectsPanel;
    private JScrollPane projectsScrollPane;
    private JPanel recentPanel;
    private JPanel samplesPanel;
    private JPanel southPanel;

    private WelcomeTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(WelcomeTopComponent.class, (String)"CTL_WelcomeTopComponent"));
        this.putClientProperty("netbeans.winsys.tc.dragging_disabled", Boolean.TRUE);
        this.putClientProperty("netbeans.winsys.tc.maximization_disabled", Boolean.TRUE);
        this.initAction();
        this.loadProjects();
        this.loadMRU();
        this.loadSamples();
        this.loadPrefs();
    }

    public static synchronized WelcomeTopComponent getInstance() {
        if (instance == null) {
            instance = new WelcomeTopComponent();
        }
        return instance;
    }

    private void closeDialog() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Container container = WelcomeTopComponent.this;
                while (!(container instanceof JDialog)) {
                    container = container.getParent();
                }
                ((Component)container).setVisible(false);
            }
        });
    }

    private void initAction() {
        this.openFileAction = new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                JXHyperlink link = (JXHyperlink)e.getSource();
                File file = (File)link.getClientProperty(LINK_PATH);
                Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(new ActionEvent(file, 0, null));
                WelcomeTopComponent.this.closeDialog();
            }
        };
        this.newProjectLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.NewProject").actionPerformed(null);
                WelcomeTopComponent.this.closeDialog();
            }
        });
        this.openFileLink.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Actions.forID((String)"File", (String)"org.gephi.desktop.project.actions.OpenFile").actionPerformed(null);
                WelcomeTopComponent.this.closeDialog();
            }
        });
    }

    private void loadProjects() {
        MigLayout migLayout1 = new MigLayout("insets 6");
        migLayout1.setColumnConstraints((Object)"[pref]");
        this.projectsPanel.setLayout((LayoutManager)migLayout1);
        ProjectController pc = (ProjectController)Lookup.getDefault().lookup(ProjectController.class);
        for (Project project : pc.getAllProjects()) {
            if (!project.hasFile()) continue;
            JLabel iconLabel = new JLabel(ImageUtilities.loadImageIcon((String)"WelcomeScreen/gephifile20.png", (boolean)false));
            this.projectsPanel.add((Component)iconLabel, "span 1 2, aligny top");
            JXHyperlink link = new JXHyperlink(this.openFileAction);
            link.setText(project.getName());
            link.setToolTipText(project.getFile().getPath());
            link.putClientProperty(LINK_PATH, (Object)project.getFile());
            this.projectsPanel.add((Component)link, "wrap 0");
            JLabel fileLabel = new JLabel(project.getFile().getName());
            fileLabel.setFont(fileLabel.getFont().deriveFont((float)fileLabel.getFont().getSize() - 2.0f));
            fileLabel.setForeground(UIManager.getColor("Label.disabledForeground"));
            this.projectsPanel.add((Component)fileLabel, "gapleft 2, wrap 6");
        }
    }

    private void loadMRU() {
        MigLayout migLayout1 = new MigLayout("insets 6");
        migLayout1.setColumnConstraints((Object)"[pref]");
        this.recentPanel.setLayout((LayoutManager)migLayout1);
        MostRecentFiles mru = (MostRecentFiles)Lookup.getDefault().lookup(MostRecentFiles.class);
        for (String filePath : mru.getMRUFileList()) {
            JXHyperlink fileLink = new JXHyperlink(this.openFileAction);
            File file = new File(filePath);
            if (!file.exists()) continue;
            fileLink.setText(file.getName());
            fileLink.setToolTipText(file.getPath());
            fileLink.putClientProperty(LINK_PATH, (Object)file);
            this.recentPanel.add((Component)fileLink, "wrap");
        }
    }

    private void loadSamples() {
        MigLayout migLayout1 = new MigLayout("insets 6");
        migLayout1.setColumnConstraints((Object)"[pref]");
        this.samplesPanel.setLayout((LayoutManager)migLayout1);
        String[] samplePath = new String[]{"/org/gephi/desktop/welcome/samples/Les Miserables.gexf", "/org/gephi/desktop/welcome/samples/Java.gexf", "/org/gephi/desktop/welcome/samples/Power Grid.gml", "/org/gephi/desktop/welcome/samples/US Airports.gexf"};
        String[] sampleTooltip = new String[]{"Coappearance Network of Characters in 'Les Miserables' (D. E. Knuth)", "Java Programming Language Dependency graph (V. Batagelj)", "Topology of the Western States Power Grid of the US (D. Watts & S. Strogatz)", "Example of a geographical network with latitude/longitude attributes"};
        try {
            for (int i = 0; i < samplePath.length; ++i) {
                final String s = samplePath[i];
                String tooltip = sampleTooltip[i];
                String fileName = s.substring(s.lastIndexOf(47) + 1);
                final String importer = fileName.substring(fileName.lastIndexOf(46));
                final String fileNameNoExt = fileName.substring(0, fileName.lastIndexOf(46));
                JXHyperlink fileLink = new JXHyperlink((Action)new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InputStream stream = WelcomeTopComponent.class.getResourceAsStream(s);
                        ImportControllerUI importController = (ImportControllerUI)Lookup.getDefault().lookup(ImportControllerUI.class);
                        importController.importStream(stream, fileNameNoExt, importer);
                        WelcomeTopComponent.this.closeDialog();
                    }
                });
                fileLink.setText(fileName);
                fileLink.setToolTipText(tooltip);
                fileLink.putClientProperty(LINK_PATH, (Object)importer);
                this.samplesPanel.add((Component)fileLink, "wrap");
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void loadPrefs() {
        boolean openStartup = NbPreferences.forModule(WelcomeTopComponent.class).getBoolean(STARTUP_PREF, Boolean.TRUE);
        this.openOnStartupCheckbox.setSelected(openStartup);
        this.openOnStartupCheckbox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                NbPreferences.forModule(WelcomeTopComponent.class).putBoolean(WelcomeTopComponent.STARTUP_PREF, WelcomeTopComponent.this.openOnStartupCheckbox.isSelected());
            }
        });
    }

    private void initComponents() {
        this.header = new JXHeader();
        this.mainPanel = new JPanel();
        this.labelRecent = new JLabel();
        this.labelNew = new JLabel();
        this.newProjectLink = new JXHyperlink();
        this.labelSamples = new JLabel();
        this.samplesPanel = new JPanel();
        this.openFileLink = new JXHyperlink();
        this.labelProjects = new JLabel();
        this.projectsScrollPane = new JScrollPane();
        this.projectsPanel = new JPanel();
        this.recentPanel = new JPanel();
        this.southPanel = new JPanel();
        this.openOnStartupCheckbox = new JCheckBox();
        this.setPreferredSize(new Dimension(679, 379));
        this.setLayout(new BorderLayout());
        this.header.setBorder((Border)new DropShadowBorder());
        this.header.setIcon((Icon)ImageUtilities.loadImageIcon((String)"WelcomeScreen/logo_transparent_small.png", (boolean)false));
        this.header.setTitle(NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.header.title"));
        this.header.setTitleFont(this.header.getTitleFont().deriveFont((float)this.header.getTitleFont().getSize() + 4.0f));
        this.header.setTitleForeground(new Color(39, 119, 198));
        this.add((Component)this.header, "First");
        this.labelRecent.setFont(this.labelRecent.getFont().deriveFont(this.labelRecent.getFont().getStyle() | 1, this.labelRecent.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelRecent, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelRecent.text"));
        this.labelNew.setFont(this.labelNew.getFont().deriveFont(this.labelNew.getFont().getStyle() | 1, this.labelNew.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelNew, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelNew.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newProjectLink, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.newProjectLink.text"));
        this.labelSamples.setFont(this.labelSamples.getFont().deriveFont(this.labelSamples.getFont().getStyle() | 1, this.labelSamples.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelSamples, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelSamples.text"));
        this.samplesPanel.setOpaque(false);
        Mnemonics.setLocalizedText((AbstractButton)this.openFileLink, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.openFileLink.text"));
        this.labelProjects.setFont(this.labelProjects.getFont().deriveFont(this.labelProjects.getFont().getStyle() | 1, this.labelProjects.getFont().getSize() + 2));
        Mnemonics.setLocalizedText((JLabel)this.labelProjects, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.labelProjects.text"));
        this.projectsScrollPane.setBorder(null);
        this.projectsScrollPane.setHorizontalScrollBarPolicy(31);
        GroupLayout projectsPanelLayout = new GroupLayout(this.projectsPanel);
        this.projectsPanel.setLayout(projectsPanelLayout);
        projectsPanelLayout.setHorizontalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 375, Short.MAX_VALUE));
        projectsPanelLayout.setVerticalGroup(projectsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 168, Short.MAX_VALUE));
        this.projectsScrollPane.setViewportView(this.projectsPanel);
        GroupLayout recentPanelLayout = new GroupLayout(this.recentPanel);
        this.recentPanel.setLayout(recentPanelLayout);
        recentPanelLayout.setHorizontalGroup(recentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        recentPanelLayout.setVerticalGroup(recentPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(20, 20, 20).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectsScrollPane, -1, 288, Short.MAX_VALUE).addGroup(mainPanelLayout.createSequentialGroup().addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelProjects).addComponent(this.labelNew).addGroup(mainPanelLayout.createSequentialGroup().addGap(6, 6, 6).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.newProjectLink, -2, -1, -2).addComponent((Component)this.openFileLink, -2, -1, -2)))).addGap(0, 0, Short.MAX_VALUE))).addGap(18, 18, 18).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.labelSamples).addComponent(this.labelRecent).addComponent(this.recentPanel, -1, -1, Short.MAX_VALUE).addComponent(this.samplesPanel, -2, 260, -2)).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(15, 15, 15).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelNew).addComponent(this.labelRecent)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent((Component)this.newProjectLink, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.openFileLink, -2, -1, -2).addGap(18, 18, 18).addComponent(this.labelProjects).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.projectsScrollPane)).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.recentPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.labelSamples).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.samplesPanel, -2, 106, -2))).addContainerGap()));
        this.add((Component)this.mainPanel, "Center");
        this.southPanel.setLayout(new FlowLayout(0));
        Mnemonics.setLocalizedText((AbstractButton)this.openOnStartupCheckbox, (String)NbBundle.getMessage(WelcomeTopComponent.class, (String)"WelcomeTopComponent.openOnStartupCheckbox.text"));
        this.southPanel.add(this.openOnStartupCheckbox);
        this.add((Component)this.southPanel, "South");
    }
}

