/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.statistics.plugin;

import javax.swing.JPanel;
import org.gephi.statistics.plugin.EigenvectorCentrality;
import org.gephi.statistics.spi.Statistics;
import org.gephi.statistics.spi.StatisticsUI;
import org.gephi.ui.statistics.plugin.EigenvectorCentralityPanel;
import org.openide.util.NbBundle;

public class EigenvectorCentralityUI
implements StatisticsUI {
    private final StatSettings settings = new StatSettings();
    private EigenvectorCentralityPanel panel;
    private EigenvectorCentrality eigen;

    public JPanel getSettingsPanel() {
        this.panel = new EigenvectorCentralityPanel();
        return this.panel;
    }

    public void setup(Statistics statistics) {
        this.eigen = (EigenvectorCentrality)statistics;
        if (this.panel != null) {
            this.settings.load(this.eigen);
            this.panel.setNumRuns(this.eigen.getNumRuns());
            this.panel.setDirected(this.eigen.isDirected());
        }
    }

    public void unsetup() {
        if (this.panel != null) {
            this.eigen.setNumRuns(this.panel.getNumRuns());
            this.eigen.setDirected(this.panel.isDirected());
            this.settings.save(this.eigen);
        }
        this.panel = null;
        this.eigen = null;
    }

    public Class<? extends Statistics> getStatisticsClass() {
        return EigenvectorCentrality.class;
    }

    public String getValue() {
        return null;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(this.getClass(), (String)"EigenvectorCentralityUI.name");
    }

    public String getCategory() {
        return StatisticsUI.CATEGORY_NODE_OVERVIEW;
    }

    public int getPosition() {
        return 1000;
    }

    public String getShortDescription() {
        return NbBundle.getMessage(this.getClass(), (String)"EigenvectorCentralityUI.shortDescription");
    }

    private static class StatSettings {
        private int mNumRuns = 100;

        private StatSettings() {
        }

        private void save(EigenvectorCentrality stat) {
            this.mNumRuns = stat.getNumRuns();
        }

        private void load(EigenvectorCentrality stat) {
            stat.setNumRuns(this.mNumRuns);
        }
    }
}

