/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.lang.ref.SoftReference;
import java.util.Map;
import org.openide.util.BaseUtilities;
import org.openide.util.RequestProcessor;

final class TimedSoftReference<T>
extends SoftReference<T>
implements Runnable {
    private static final int TIMEOUT = 30000;
    private static final RequestProcessor RP = new RequestProcessor("TimedSoftReference");
    private RequestProcessor.Task task;
    private T o;
    private final Map m;
    private final Object k;
    private long touched;

    TimedSoftReference(T o, Map m, Object k) {
        super(o, BaseUtilities.activeReferenceQueue());
        this.o = o;
        this.m = m;
        this.k = k;
        try {
            this.task = RP.create(this);
            this.task.schedule(30000);
        }
        catch (SecurityException ex) {
            this.o = null;
            this.task = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Map map = this.m;
        synchronized (map) {
            if (this.o != null) {
                long unused = System.currentTimeMillis() - this.touched;
                if (unused > 15000L) {
                    this.o = null;
                    this.touched = 0L;
                } else {
                    this.task.schedule(30000 - (int)unused);
                }
            } else {
                this.m.remove(this.k);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        Map map = this.m;
        synchronized (map) {
            if (this.o == null) {
                this.o = super.get();
            }
            if (this.o != null) {
                if (this.touched == 0L && this.task != null) {
                    this.task.schedule(30000);
                }
                this.touched = System.currentTimeMillis();
                return this.o;
            }
            return null;
        }
    }
}

