import { jsx, jsxs, Fragment } from 'react/jsx-runtime';
import { Tooltip, Button } from '@grafana/ui';

const RunQueryButton = ({
  ariaLabel = "Query editor Run button",
  queryRunning = false,
  queryInvalid = false,
  invalidQueryTooltip,
  disabled = false,
  onClick,
  dataTestId
}) => {
  let icon = queryInvalid ? "exclamation-triangle" : undefined;
  if (queryRunning) {
    icon = "fa fa-spinner";
  }
  const RunButton = /* @__PURE__ */ jsx(
    Button,
    {
      "aria-label": ariaLabel,
      size: "sm",
      variant: "secondary",
      icon,
      disabled: disabled || queryRunning,
      onClick,
      "data-testid": dataTestId,
      children: "Run query"
    }
  );
  return queryInvalid ? /* @__PURE__ */ jsx(
    Tooltip,
    {
      theme: "error",
      placement: "top",
      content: invalidQueryTooltip != null ? invalidQueryTooltip : /* @__PURE__ */ jsxs(Fragment, { children: [
        "Your query is invalid. Check below for details. ",
        /* @__PURE__ */ jsx("br", {}),
        "However, you can still run this query."
      ] }),
      children: RunButton
    }
  ) : RunButton;
};

export { RunQueryButton };
//# sourceMappingURL=RunQueryButton.js.map
