import { jsxs, Fragment, jsx } from 'react/jsx-runtime';
import { useAsync } from 'react-use';
import '../types.js';
import { QueryToolbox } from '../query-editor-raw/QueryToolbox.js';
import { Preview } from './Preview.js';
import { SQLGroupByRow } from './SQLGroupByRow.js';
import { SQLOrderByRow } from './SQLOrderByRow.js';
import { SQLSelectRow } from './SQLSelectRow.js';
import { SQLWhereRow } from './SQLWhereRow.js';
import '@grafana/data';
import { EditorRow } from './EditorRow.js';
import { EditorField } from './EditorField.js';
import { EditorRows } from './EditorRows.js';

const VisualEditor = ({ query, db, queryRowFilter, onChange, onValidate, range }) => {
  const state = useAsync(async () => {
    const fields = await db.fields(query);
    return fields;
  }, [db, query.dataset, query.table]);
  return /* @__PURE__ */ jsxs(Fragment, { children: [
    /* @__PURE__ */ jsxs(EditorRows, { children: [
      /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(SQLSelectRow, { fields: state.value || [], query, onQueryChange: onChange, db }) }),
      queryRowFilter.filter && /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(EditorField, { label: "Filter by column value", optional: true, children: /* @__PURE__ */ jsx(SQLWhereRow, { fields: state.value || [], query, onQueryChange: onChange, db }) }) }),
      queryRowFilter.group && /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(EditorField, { label: "Group by column", children: /* @__PURE__ */ jsx(SQLGroupByRow, { fields: state.value || [], query, onQueryChange: onChange, db }) }) }),
      queryRowFilter.order && /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(SQLOrderByRow, { fields: state.value || [], query, onQueryChange: onChange, db }) }),
      queryRowFilter.preview && query.rawSql && /* @__PURE__ */ jsx(EditorRow, { children: /* @__PURE__ */ jsx(Preview, { rawSql: query.rawSql }) })
    ] }),
    /* @__PURE__ */ jsx(QueryToolbox, { db, query, onValidate, range })
  ] });
};

export { VisualEditor };
//# sourceMappingURL=VisualEditor.js.map
