import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { useToggle } from 'react-use';
import { getValueFormat } from '@grafana/data';
import { config } from '@grafana/runtime';
import { useStyles2, Collapse, Tooltip, Icon } from '@grafana/ui';
import 'react';
import '../../QueryEditor/types.js';
import 'lodash';
import '../../QueryEditor/EditorList.js';
import { EditorStack } from '../../QueryEditor/EditorStack.js';
import '../../QueryEditor/Space.js';
import '../../QueryEditor/QueryHeader.js';
import 'react-virtualized-auto-sizer';
import 'sql-formatter-plus';
import '../../SQLEditor/standardSql/language.js';
import 'uuid';
import '../../SQLEditor/utils/debugger.js';
import '../../SQLEditor/standardSql/macros.js';
import '../../QueryEditor/visual-query-builder/AwesomeQueryBuilder.js';
import '../../QueryEditor/visual-query-builder/WhereRow.js';
import '../../QueryEditor/visual-query-builder/EditorField.js';
import 'rxjs';
import 'rxjs/operators';

function QueryOptionGroup({ title, children, collapsedInfo, queryStats }) {
  const [isOpen, toggleOpen] = useToggle(false);
  const styles = useStyles2(getStyles);
  return /* @__PURE__ */ jsxs("div", { className: styles.wrapper, children: [
    /* @__PURE__ */ jsx(
      Collapse,
      {
        className: styles.collapse,
        collapsible: true,
        isOpen,
        onToggle: toggleOpen,
        label: /* @__PURE__ */ jsxs(EditorStack, { gap: 0, children: [
          /* @__PURE__ */ jsx("h6", { className: styles.title, children: title }),
          !isOpen && /* @__PURE__ */ jsx("div", { className: styles.description, children: collapsedInfo.map((x, i) => /* @__PURE__ */ jsx("span", { children: x }, i)) })
        ] }),
        children: /* @__PURE__ */ jsx("div", { className: styles.body, children })
      }
    ),
    queryStats && config.featureToggles.lokiQuerySplitting && /* @__PURE__ */ jsx(Tooltip, { content: "Note: the query will be split into multiple parts and executed in sequence. Query limits will only apply each individual part.", children: /* @__PURE__ */ jsx(Icon, { tabIndex: 0, name: "info-circle", className: styles.tooltip, size: "sm" }) }),
    queryStats && /* @__PURE__ */ jsx("p", { className: styles.stats, children: generateQueryStats(queryStats) })
  ] });
}
const getStyles = (theme) => {
  return {
    collapse: css({
      backgroundColor: "unset",
      border: "unset",
      marginBottom: 0,
      ["> button"]: {
        padding: theme.spacing(0, 1)
      }
    }),
    wrapper: css({
      width: "100%",
      display: "flex",
      justifyContent: "space-between",
      alignItems: "baseline"
    }),
    title: css({
      flexGrow: 1,
      overflow: "hidden",
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      margin: 0
    }),
    description: css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.bodySmall.fontWeight,
      paddingLeft: theme.spacing(2),
      gap: theme.spacing(2),
      display: "flex"
    }),
    body: css({
      display: "flex",
      gap: theme.spacing(2),
      flexWrap: "wrap"
    }),
    stats: css({
      margin: "0px",
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize
    }),
    tooltip: css({
      marginRight: theme.spacing(0.25)
    })
  };
};
const generateQueryStats = (queryStats) => {
  if (queryStats.message) {
    return queryStats.message;
  }
  return `This query will process approximately ${convertUnits(queryStats)}.`;
};
const convertUnits = (queryStats) => {
  const { text, suffix } = getValueFormat("bytes")(queryStats.bytes, 1);
  return text + suffix;
};

export { QueryOptionGroup };
//# sourceMappingURL=QueryOptionGroup.js.map
