/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.assertj.core.internal.BinaryDiffResult;

public class BinaryDiff {
    public BinaryDiffResult diff(File actual, byte[] expected) throws IOException {
        return this.diff(actual.toPath(), expected);
    }

    public BinaryDiffResult diff(Path actual, byte[] expected) throws IOException {
        try (BufferedInputStream actualStream = new BufferedInputStream(Files.newInputStream(actual, new OpenOption[0]));){
            BinaryDiffResult binaryDiffResult = this.diff((InputStream)actualStream, expected);
            return binaryDiffResult;
        }
    }

    public BinaryDiffResult diff(InputStream actualStream, byte[] expected) throws IOException {
        return this.diff(actualStream, new ByteArrayInputStream(expected));
    }

    public BinaryDiffResult diff(InputStream actualStream, InputStream expectedStream) throws IOException {
        int index = 0;
        while (true) {
            int actual = actualStream.read();
            int expected = expectedStream.read();
            if (actual == -1 && expected == -1) {
                return BinaryDiffResult.noDiff();
            }
            if (actual != expected) {
                return new BinaryDiffResult(index, expected, actual);
            }
            ++index;
        }
    }
}

