/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.internal;

import java.io.Serializable;
import java.util.Comparator;
import org.hibernate.SharedSessionContract;
import org.hibernate.annotations.Immutable;
import org.hibernate.dialect.Dialect;
import org.hibernate.type.CustomType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.converter.spi.BasicValueConverter;
import org.hibernate.type.descriptor.java.BasicJavaType;
import org.hibernate.type.descriptor.java.ImmutableMutabilityPlan;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.MutabilityPlan;
import org.hibernate.type.descriptor.java.MutabilityPlanExposer;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcTypeIndicators;
import org.hibernate.usertype.EnhancedUserType;
import org.hibernate.usertype.UserType;

public class UserTypeJavaTypeWrapper<J>
implements BasicJavaType<J> {
    protected final UserType<J> userType;
    private final MutabilityPlan<J> mutabilityPlan;
    private final CustomType<J> customType;
    private final Comparator<J> comparator;

    public UserTypeJavaTypeWrapper(UserType<J> userType, CustomType<J> customType) {
        this.userType = userType;
        this.mutabilityPlan = this.resolveMutabilityPlan(userType);
        this.customType = customType;
        this.comparator = userType instanceof Comparator ? (Comparator)((Object)userType) : this::compare;
    }

    private MutabilityPlan<J> resolveMutabilityPlan(UserType<J> userType) {
        if (userType instanceof MutabilityPlanExposer) {
            return ((MutabilityPlanExposer)((Object)userType)).getExposedMutabilityPlan();
        }
        Class<J> jClass = userType.returnedClass();
        if (jClass != null && jClass.getAnnotation(Immutable.class) != null) {
            return ImmutableMutabilityPlan.instance();
        }
        return new MutabilityPlanWrapper(userType);
    }

    private int compare(J first, J second) {
        return this.userType.equals(first, second) ? 0 : Comparator.comparing(this.userType::hashCode).compare(first, second);
    }

    @Override
    public MutabilityPlan<J> getMutabilityPlan() {
        return this.mutabilityPlan;
    }

    @Override
    public JdbcType getRecommendedJdbcType(JdbcTypeIndicators context) {
        return context.getJdbcType(this.userType.getSqlType());
    }

    @Override
    public long getDefaultSqlLength(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlLength(dialect, jdbcType);
    }

    @Override
    public int getDefaultSqlPrecision(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlPrecision(dialect, jdbcType);
    }

    @Override
    public int getDefaultSqlScale(Dialect dialect, JdbcType jdbcType) {
        return this.userType.getDefaultSqlScale(dialect, jdbcType);
    }

    @Override
    public Comparator<J> getComparator() {
        return this.comparator;
    }

    @Override
    public int extractHashCode(J value) {
        return this.userType.hashCode(value);
    }

    @Override
    public boolean areEqual(J one, J another) {
        return this.userType.equals(one, another);
    }

    @Override
    public J fromString(CharSequence string) {
        UserType<J> userType = this.userType;
        if (userType instanceof EnhancedUserType) {
            EnhancedUserType enhancedUserType = (EnhancedUserType)userType;
            return enhancedUserType.fromStringValue(string);
        }
        throw new UnsupportedOperationException("No support for parsing UserType values from String: " + String.valueOf(this.userType));
    }

    @Override
    public String toString(J value) {
        String string;
        UserType<J> userType;
        if (this.userType.returnedClass().isInstance(value) && (userType = this.userType) instanceof EnhancedUserType) {
            EnhancedUserType enhancedUserType = (EnhancedUserType)userType;
            string = enhancedUserType.toString(value);
        } else {
            string = value == null ? "null" : value.toString();
        }
        return string;
    }

    @Override
    public <X> X unwrap(J value, Class<X> type, WrapperOptions options) {
        return this.unwrap(value, type, this.customType.getValueConverter(), options);
    }

    private <X, R> X unwrap(J value, Class<X> type, BasicValueConverter<J, R> converter, WrapperOptions options) {
        if (value != null && !type.isInstance(value) && converter != null) {
            Object relationalValue = this.customType.convertToRelationalValue(value);
            JavaType<R> relationalJavaType = converter.getRelationalJavaType();
            assert (relationalJavaType.isInstance(relationalValue));
            return relationalJavaType.unwrap(relationalValue, type, options);
        }
        return (X)value;
    }

    @Override
    public <X> J wrap(X value, WrapperOptions options) {
        BasicValueConverter<J, ?> converter = this.customType.getValueConverter();
        if (value != null && !this.userType.returnedClass().isInstance(value) && converter != null) {
            JavaType<J> domainJavaType = converter.getDomainJavaType();
            Object domainValue = this.customType.convertToDomainValue(value);
            assert (domainJavaType.isInstance(value));
            return domainJavaType.wrap(domainValue, options);
        }
        return (J)value;
    }

    @Override
    public Class<J> getJavaTypeClass() {
        return this.userType.returnedClass();
    }

    public class MutabilityPlanWrapper
    implements MutabilityPlan<J> {
        private final UserType<J> userType;

        public MutabilityPlanWrapper(UserType<J> userType) {
            this.userType = userType;
        }

        @Override
        public boolean isMutable() {
            return this.userType.isMutable();
        }

        @Override
        public J deepCopy(J value) {
            return this.userType.deepCopy(value);
        }

        @Override
        public Serializable disassemble(J value, SharedSessionContract session) {
            Serializable disassembled = this.userType.disassemble(value);
            return disassembled == null && value != null ? this.disassemble(value, UserTypeJavaTypeWrapper.this.customType.getValueConverter(), session) : disassembled;
        }

        private <R> Serializable disassemble(J value, BasicValueConverter<J, R> converter, SharedSessionContract session) {
            if (converter == null) {
                return (Serializable)value;
            }
            Object converted = UserTypeJavaTypeWrapper.this.customType.convertToRelationalValue(value);
            return converter.getRelationalJavaType().getMutabilityPlan().disassemble(converted, session);
        }

        @Override
        public J assemble(Serializable cached, SharedSessionContract session) {
            Object assembled = this.userType.assemble(cached, null);
            return assembled == null && cached != null ? this.disassemble(cached, UserTypeJavaTypeWrapper.this.customType.getValueConverter(), session) : assembled;
        }

        private J disassemble(Serializable cached, BasicValueConverter<J, ?> converter, SharedSessionContract session) {
            if (converter == null) {
                return cached;
            }
            Object assembled = converter.getRelationalJavaType().getMutabilityPlan().assemble(cached, session);
            return UserTypeJavaTypeWrapper.this.customType.convertToDomainValue(assembled);
        }
    }
}

