/*
 * Decompiled with CFR 0.152.
 */
package io.agroal.pool.util;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public abstract class AutoCloseableElement
implements AutoCloseable {
    private static final AtomicReferenceFieldUpdater<AutoCloseableElement, AutoCloseableElement> NEXT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(AutoCloseableElement.class, AutoCloseableElement.class, "nextElement");
    private volatile AutoCloseableElement nextElement;

    public abstract boolean isClosed() throws Exception;

    protected abstract boolean internalClosed();

    protected AutoCloseableElement(AutoCloseableElement head) {
        if (head != null) {
            do {
                this.nextElement = head.getNextElement();
            } while (!head.setNextElement(this.nextElement, this));
        }
    }

    public int closeAllAutocloseableElements() {
        int count = 0;
        for (AutoCloseableElement next = this.resetNextElement(); next != null; next = next.resetNextElement()) {
            try {
                if (next.internalClosed()) continue;
                ++count;
                if (next instanceof Statement) {
                    try {
                        ((Statement)((Object)next)).cancel();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                next.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return count;
    }

    private boolean setNextElement(AutoCloseableElement expected, AutoCloseableElement element) {
        return NEXT_UPDATER.compareAndSet(this, expected, element);
    }

    private AutoCloseableElement getNextElement() {
        return NEXT_UPDATER.get(this);
    }

    private AutoCloseableElement resetNextElement() {
        return NEXT_UPDATER.getAndSet(this, null);
    }

    public void pruneClosed() {
        AutoCloseableElement next = this.nextElement;
        while (next != null && next.internalClosed() && this.setNextElement(next, next.nextElement)) {
            next = this.nextElement;
        }
    }

    public static AutoCloseableElement newHead() {
        return new AutoCloseableElementHead();
    }

    private static class AutoCloseableElementHead
    extends AutoCloseableElement {
        private AutoCloseableElementHead() {
            super(null);
        }

        @Override
        public boolean isClosed() {
            throw new IllegalStateException();
        }

        @Override
        public void close() throws Exception {
            throw new IllegalStateException();
        }

        @Override
        protected boolean internalClosed() {
            return false;
        }
    }
}

