/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.Phaser;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import oracle.jdbc.ErrorSet;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.diagnostics.CommonDiagnosable;
import oracle.jdbc.diagnostics.SecurityLabel;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LobSegmentSubscriber;
import oracle.jdbc.driver.PhasedPublisher;
import oracle.jdbc.driver.Pipeline;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.internal.OracleLargeObject;
import oracle.sql.BLOB;
import oracle.sql.BlobDBAccess;
import oracle.sql.Datum;
import oracle.sql.DatumWithConnection;

@Deprecated
public class OracleBlob
extends DatumWithConnection
implements oracle.jdbc.internal.OracleBlob {
    private static final long serialVersionUID = -5771953664462518027L;
    private static final String CLASS_NAME = OracleBlob.class.getName();
    public static final int MAX_CHUNK_SIZE = 32768;
    public static final int DURATION_SESSION = 10;
    public static final int DURATION_CALL = 12;
    static final int OLD_WRONG_DURATION_SESSION = 1;
    static final int OLD_WRONG_DURATION_CALL = 2;
    public static final int MODE_READONLY = 0;
    public static final int MODE_READWRITE = 1;
    BlobDBAccess dbaccess;
    int dbChunkSize = -1;
    boolean isFree = false;
    boolean fromObject = false;
    private long cachedLobLength = -1L;
    private OracleLargeObject.PrefetchData<byte[]> prefetchData;
    private boolean activePrefetch = false;
    static final int KDLCTLSIZE = 16;
    static final int KDF_FLAG = 88;
    static final int KDLIDDAT = 8;
    Object acProxy;
    private volatile boolean isPublishing = false;
    private final ReentrantLock publishingLock = new ReentrantLock();
    private final Condition publishingCondition = this.publishingLock.newCondition();

    public OracleBlob() {
    }

    public OracleBlob(OracleConnection conn) throws SQLException {
        this(conn, null);
    }

    public OracleBlob(OracleConnection conn, byte[] lob_descriptor, boolean fromObject) throws SQLException {
        this(conn, lob_descriptor);
        this.fromObject = fromObject;
    }

    public OracleBlob(OracleConnection conn, byte[] lob_descriptor) throws SQLException {
        super(lob_descriptor);
        OracleBlob.assertNotNull(conn);
        this.setPhysicalConnectionOf(conn);
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            this.dbaccess = this.getPhysicalConnection().createBlobDBAccess();
            this.dbaccess.incrementTempLobReferenceCount(lob_descriptor);
            if (lob_descriptor != null && !this.isTemporaryInternal(this.dbaccess)) {
                ((oracle.jdbc.internal.OracleConnection)conn).addLargeObject(this);
            }
        }
    }

    public void setFromobject(boolean fromObject) {
        this.fromObject = fromObject;
    }

    @Override
    public long length() throws SQLException {
        this.awaitPublishing();
        return this.lengthInternal();
    }

    @Override
    public final long lengthInternal() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        long ret = this.activePrefetch && this.cachedLobLength != -1L ? this.cachedLobLength : (this.canReadBasicLobDataInLocator() ? (long)this.dilLength() : this.getDBAccess().length(this));
        return ret;
    }

    @Override
    public final CompletionStage<Long> lengthInternalAsync() {
        if (this.isFree) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        try {
            if (this.activePrefetch && this.cachedLobLength != -1L) {
                return CompletableFuture.completedStage(this.cachedLobLength);
            }
            if (this.canReadBasicLobDataInLocator()) {
                return CompletableFuture.completedStage(Long.valueOf(this.dilLength()));
            }
            return this.getDBAccess().lengthAsync(this);
        }
        catch (SQLException sqlException) {
            return CompletableFuture.failedStage(sqlException);
        }
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBytes(pos, length);
        }
        if (length == 0) {
            return new byte[0];
        }
        byte[] ret = null;
        if (this.activePrefetch && (this.cachedLobLength == 0L || this.cachedLobLength > 0L && pos - 1L >= this.cachedLobLength)) {
            ret = null;
        } else {
            long num_bytes_read = 0L;
            byte[] bytes_read = this.activePrefetch && this.cachedLobLength != -1L ? new byte[Math.min((int)this.cachedLobLength, length)] : new byte[length];
            num_bytes_read = this.getBytes(pos, length, bytes_read);
            if (num_bytes_read > 0L) {
                if (num_bytes_read == (long)length) {
                    ret = bytes_read;
                } else {
                    ret = new byte[(int)num_bytes_read];
                    System.arraycopy(bytes_read, 0, ret, 0, (int)num_bytes_read);
                }
            }
        }
        return ret;
    }

    @Override
    public final Flow.Publisher<byte[]> publisherOracle(final long startPosition, final ErrorSet continueOnErrorSet) throws SQLException {
        if (!this.getDBAccess().isAsyncBlobGetSupported()) {
            throw new SQLFeatureNotSupportedException("Asynchronous publishing is not supported by " + this.getInternalConnection().getProtocolType() + " connections.");
        }
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (startPosition < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        Pipeline.requireSupportedErrorSet(continueOnErrorSet);
        this.lockBeforePublishing();
        return new PhasedPublisher<byte[]>(this.getInternalConnection().getAsyncExecutor(), this.getInternalConnection().getJoinPhaser(), this::unlockAfterPublishing){
            volatile long position;
            {
                super(executor, joinPhaser, terminalAction);
                this.position = startPosition;
            }

            @Override
            protected void requestNext(BiConsumer<byte[], Throwable> callback) {
                CompletionStageUtil.callOnComplete(OracleBlob.this.getBufferSizeAsync(), (bufferSize, error) -> CompletionStageUtil.callOnComplete(error == null ? OracleBlob.this.getBytesAsync(this.position, (int)bufferSize, continueOnErrorSet).thenApply(nextBytes -> {
                    if (nextBytes != null) {
                        this.position += (long)((byte[])nextBytes).length;
                    }
                    return nextBytes;
                }) : CompletableFuture.failedFuture(error), callback));
            }
        };
    }

    private final CompletionStage<byte[]> getBytesAsync(long pos, int length, ErrorSet continueOnErrorSet) {
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        if (length < 0 || pos < 1L) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace());
        }
        try {
            if (this.canReadBasicLobDataInLocator()) {
                byte[] dilBytes = this.dilGetBytes(pos, length);
                return CompletableFuture.completedStage(dilBytes);
            }
        }
        catch (SQLException dilGetBytesFailure) {
            return CompletableFuture.failedStage(dilGetBytesFailure);
        }
        if (length == 0) {
            return CompletableFuture.completedStage(new byte[0]);
        }
        Object ret = null;
        if (this.activePrefetch && (this.cachedLobLength == 0L || this.cachedLobLength > 0L && pos - 1L >= this.cachedLobLength)) {
            return CompletableFuture.completedStage(null);
        }
        byte[] bytes_read = this.activePrefetch && this.cachedLobLength != -1L ? new byte[Math.min((int)this.cachedLobLength, length)] : new byte[length];
        return this.getBytesAsync(pos, length, bytes_read, continueOnErrorSet).thenApply(num_bytes_read -> {
            if (num_bytes_read > 0) {
                if (num_bytes_read == length) {
                    return bytes_read;
                }
                byte[] endOfBlobBytes = new byte[num_bytes_read.intValue()];
                System.arraycopy(bytes_read, 0, endOfBlobBytes, 0, num_bytes_read);
                return endOfBlobBytes;
            }
            return null;
        });
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.awaitPublishing();
        return this.getBinaryStream(false);
    }

    public InputStream getBinaryStream(boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(1L);
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getBufferSize(), 0L, isInternal);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleBlob)this, (Datum)this, pattern, start);
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().position((oracle.jdbc.internal.OracleBlob)this, (Datum)this, (Datum)((Object)pattern), start);
    }

    @Override
    public int getBytes(long pos, int length, byte[] buf) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (length < 0 || pos < 1L || buf == null) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace();
        }
        if (buf.length < length) {
            length = buf.length;
        }
        return this.getDBAccess().getBytes(this, pos, length, buf);
    }

    private CompletionStage<Integer> getBytesAsync(long pos, int length, byte[] buf, ErrorSet continueOnErrorSet) {
        BlobDBAccess dbAccess;
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        if (length < 0 || pos < 1L || buf == null) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "getBytes()").fillInStackTrace());
        }
        if (buf.length < length) {
            length = buf.length;
        }
        try {
            dbAccess = this.getDBAccess();
        }
        catch (SQLException getAccessFailure) {
            return CompletableFuture.failedStage(getAccessFailure);
        }
        return dbAccess.getBytesAsync(this, pos, length, buf, continueOnErrorSet);
    }

    @Override
    @Deprecated
    public int putBytes(long pos, byte[] bytes) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBytes(pos, bytes);
    }

    @Override
    @Deprecated
    public int putBytes(long pos, byte[] bytes, int length) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBytes(pos, bytes, 0, length);
    }

    @Override
    @Deprecated
    public OutputStream getBinaryOutputStream() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.setBinaryStream(1L);
    }

    @Override
    public byte[] getLocator() {
        return this.getBytes();
    }

    @Override
    public void setLocator(byte[] locator) {
        super.setBytes(locator);
    }

    @Override
    public int getChunkSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.dbChunkSize <= 0) {
            this.dbChunkSize = this.getDBAccess().getChunkSize(this);
        }
        return this.dbChunkSize;
    }

    @Override
    public int getBufferSize() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return OracleBlob.computeBufferSize(this.getChunkSize());
    }

    private CompletionStage<Integer> getBufferSizeAsync() {
        if (this.isFree) {
            return CompletableFuture.failedStage((SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        if (this.dbChunkSize > 0) {
            return CompletableFuture.completedStage(OracleBlob.computeBufferSize(this.dbChunkSize));
        }
        try {
            CompletableFuture<Integer> bufferSizeFuture = new CompletableFuture<Integer>();
            this.getDBAccess().getChunkSizeAsync(this, (size, error) -> {
                if (error == null) {
                    this.dbChunkSize = size;
                    bufferSizeFuture.complete(OracleBlob.computeBufferSize(this.dbChunkSize));
                } else {
                    bufferSizeFuture.completeExceptionally((Throwable)error);
                }
            });
            return bufferSizeFuture;
        }
        catch (Exception exception) {
            return CompletableFuture.failedStage(exception);
        }
    }

    @Override
    public boolean isEmptyLob() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[5] & 0x10) != 0;
        return ret;
    }

    @Override
    public boolean isSecureFile() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        boolean ret = (this.shareBytes()[7] & 0xFFFFFF80) != 0;
        return ret;
    }

    @Override
    @Deprecated
    public OutputStream getBinaryOutputStream(long pos) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, false);
    }

    @Override
    public InputStream getBinaryStream(long pos) throws SQLException {
        this.awaitPublishing();
        return this.getBinaryStream(pos, false);
    }

    public InputStream getBinaryStream(long pos, boolean isInternal) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'position data' should be > 0.").fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(pos);
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getBufferSize(), pos, isInternal);
    }

    @Override
    @Deprecated
    public void trim(long newlen) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.truncate(newlen);
    }

    @Override
    public void freeTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.freeTemporaryInternal(this.getDBAccess());
    }

    private void freeTemporaryInternal(BlobDBAccess myDBAccess) throws SQLException {
        int refCnt = myDBAccess.decrementTempLobReferenceCount(this.shareBytes());
        if (refCnt == 0) {
            myDBAccess.freeTemporary(this, this, this.fromObject);
        }
    }

    @Override
    public boolean isTemporary() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isTemporaryInternal(this.getDBAccess());
    }

    private boolean isTemporaryInternal(BlobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isTemporary(this);
    }

    @Override
    public short getDuration() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().getDuration(this);
    }

    @Override
    public void openLob(LargeObjectAccessMode mode) throws SQLException {
        this.awaitPublishing();
        this.openLob(mode.getCode());
    }

    public void openLob(int mode) throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.getDBAccess().openLob(this, mode);
    }

    @Override
    public void closeLob() throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        this.closeLobInternal(this.getDBAccess());
    }

    private void closeLobInternal(BlobDBAccess myDBAccess) throws SQLException {
        myDBAccess.closeLob(this);
    }

    @Override
    public boolean isOpenLob() throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.isOpenLobInternal(this.getDBAccess());
    }

    private boolean isOpenLobInternal(BlobDBAccess myDBAccess) throws SQLException {
        return myDBAccess.isOpenLob(this);
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putBytes(this, pos, bytes, 0, bytes != null ? bytes.length : 0);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this.getDBAccess().putBytes(this, pos, bytes, offset, len);
    }

    @Override
    public final Flow.Subscriber<byte[]> subscriberOracle(long startPosition, ErrorSet continueOnErrorSet) throws SQLException {
        return this.subscriberOracle(startPosition, LobSegmentSubscriber.NO_OUTCOME_SUBSCRIBER, continueOnErrorSet);
    }

    @Override
    public final Flow.Subscriber<byte[]> subscriberOracle(final long startPosition, Flow.Subscriber<Long> outcomeSubscriber, final ErrorSet continueOnErrorSet) throws SQLException {
        if (!this.getDBAccess().isAsyncBlobPutSupported()) {
            throw new SQLFeatureNotSupportedException("Asynchronous subscriber is not supported by " + this.getInternalConnection().getProtocolType() + " connections.");
        }
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (startPosition < 1L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, null).fillInStackTrace();
        }
        Objects.requireNonNull(outcomeSubscriber);
        Pipeline.requireSupportedErrorSet(continueOnErrorSet);
        this.lockBeforePublishing();
        Executor executor = this.getInternalConnection().getAsyncExecutor();
        Phaser joinPhaser = this.getInternalConnection().getJoinPhaser();
        joinPhaser.register();
        return CompletionStageUtil.newFutureSubscriber(this.getBufferSizeAsync().thenApply(bufferSize -> {
            final byte[] buffer = new byte[bufferSize.intValue()];
            return new LobSegmentSubscriber<byte[]>(LobSegmentSubscriber.LobSegmentBuffer.newByteBuffer(buffer), outcomeSubscriber, () -> {
                try {
                    this.unlockAfterPublishing();
                }
                finally {
                    joinPhaser.arriveAndDeregister();
                }
            }, executor, joinPhaser){
                volatile long blobPosition;
                {
                    super(buffer2, outcomeSubscriber, terminalAction, userCodeExecutor, joinPhaser);
                    this.blobPosition = startPosition;
                }

                @Override
                CompletionStage<Void> flushBufferAsync(int length) {
                    return OracleBlob.this.setAllBytesAsync(this.blobPosition, buffer, 0, length, continueOnErrorSet).whenComplete((nil, err) -> {
                        if (err == null) {
                            this.blobPosition += (long)length;
                        } else {
                            CommonDiagnosable.getInstance().debug(Level.FINEST, SecurityLabel.UNKNOWN, CLASS_NAME, "flushBufferAsync", "subscriber write failed at position={0}.", (String)null, err, (Object)this.blobPosition);
                        }
                    });
                }
            };
        }));
    }

    private final CompletionStage<Void> setAllBytesAsync(long pos, byte[] bytes, int offset, int length, ErrorSet continueOnErrorSet) {
        return this.setBytesAsync(pos, bytes, offset, length, continueOnErrorSet).thenCompose(writtenByteCount -> {
            if (writtenByteCount == length) {
                return CompletableFuture.completedStage(null);
            }
            long nextPos = pos + (long)writtenByteCount.intValue();
            int nextOffset = offset + writtenByteCount;
            int nextLength = length - writtenByteCount;
            return this.setAllBytesAsync(nextPos, bytes, nextOffset, nextLength, continueOnErrorSet);
        });
    }

    private final CompletionStage<Integer> setBytesAsync(long pos, byte[] bytes, int offset, int length, ErrorSet continueOnErrorSet) {
        BlobDBAccess dbAccess;
        if (this.isFree) {
            return CompletableFuture.failedStage(DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace());
        }
        try {
            dbAccess = this.getDBAccess();
        }
        catch (SQLException getAccessFailure) {
            return CompletableFuture.failedStage(getAccessFailure);
        }
        return dbAccess.putBytesAsync(this, pos, bytes, offset, length, continueOnErrorSet);
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (pos < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'position data' should be > 0.").fillInStackTrace();
        }
        return this.getDBAccess().newOutputStream(this, this.getBufferSize(), pos, true);
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (len < 0L) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "'len' should be >= 0. ").fillInStackTrace();
        }
        this.getDBAccess().trim(this, len);
    }

    @Override
    public Object toJdbc() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return this;
    }

    @Override
    public boolean isConvertibleTo(Class<?> jClass) {
        String class_name = jClass.getName();
        return class_name.compareTo("java.io.InputStream") == 0 || class_name.compareTo("java.io.Reader") == 0;
    }

    @Override
    public Reader characterStreamValue() throws SQLException {
        return this.characterStreamValue(false);
    }

    public Reader characterStreamValue(boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            Reader reader = this.getDBAccess().newConversionReader(this, 8, isInternal);
            return reader;
        }
    }

    @Override
    public InputStream asciiStreamValue() throws SQLException {
        return this.asciiStreamValue(false);
    }

    public InputStream asciiStreamValue(boolean isInternal) throws SQLException {
        try (Monitor.CloseableLock lock = this.getPhysicalConnection().acquireCloseableLock();){
            InputStream inputStream = this.getDBAccess().newConversionInputStream(this, 2, isInternal);
            return inputStream;
        }
    }

    @Override
    public InputStream binaryStreamValue() throws SQLException {
        return this.getBinaryStream();
    }

    @Override
    public InputStream binaryStreamValue(boolean isInternal) throws SQLException {
        return this.getBinaryStream(isInternal);
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        return new BLOB[arraySize];
    }

    @Override
    public BlobDBAccess getDBAccess() throws SQLException {
        oracle.jdbc.internal.OracleConnection connPhys = this.getPhysicalConnection();
        if (connPhys != null && connPhys.isClosed()) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 8).fillInStackTrace();
        }
        if (this.dbaccess == null) {
            if (this.isEmptyLob()) {
                throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 98).fillInStackTrace();
            }
            try (Monitor.CloseableLock lock = connPhys.acquireCloseableLock();){
                this.dbaccess = this.getInternalConnection().createBlobDBAccess();
            }
        }
        return this.dbaccess;
    }

    public static BlobDBAccess getDBAccess(Connection conn) throws SQLException {
        try (Monitor.CloseableLock lock = ((OracleConnection)conn).physicalConnectionWithin().acquireCloseableLock();){
            BlobDBAccess blobDBAccess = ((OracleConnection)conn).physicalConnectionWithin().createBlobDBAccess();
            return blobDBAccess;
        }
    }

    @Override
    public Connection getJavaSqlConnection() throws SQLException {
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        return super.getJavaSqlConnection();
    }

    @Override
    public final void setLength(long _length) {
        this.cachedLobLength = _length;
    }

    @Override
    public final void setChunkSize(int _dbChunkSize) {
        this.dbChunkSize = _dbChunkSize;
    }

    @Override
    public final void setPrefetchData(OracleLargeObject.PrefetchData<byte[]> prefetchData) {
        this.prefetchData = prefetchData;
    }

    @Override
    public final OracleLargeObject.PrefetchData<byte[]> getPrefetchData() {
        return this.prefetchData;
    }

    @Override
    public final void setActivePrefetch(boolean _activePrefetch) {
        if (this.activePrefetch && !_activePrefetch) {
            this.clearCachedData();
        }
        this.activePrefetch = _activePrefetch;
    }

    @Override
    public final void clearCachedData() {
        this.cachedLobLength = -1L;
        this.prefetchData = null;
    }

    @Override
    public final boolean isActivePrefetch() {
        return this.activePrefetch;
    }

    @Override
    public boolean canReadBasicLobDataInLocator() throws SQLException {
        byte[] loc = this.shareBytes();
        if (loc == null || loc.length < 102) {
            return false;
        }
        if (!this.getPhysicalConnection().isDataInLocatorEnabled()) {
            return false;
        }
        int kol_field3 = loc[6] & 0xFF;
        int kol_field4 = loc[7] & 0xFF;
        boolean hasDILBit = (kol_field3 & 8) == 8;
        boolean hasLocalBit = (kol_field4 & 0xFFFFFF80) == -128;
        boolean hasKdfBit = false;
        if (hasDILBit && !hasLocalBit) {
            int kdf_field = loc[88] & 0xFF;
            hasKdfBit = (kdf_field & 8) == 8;
        }
        boolean canUseDILData = hasDILBit && !hasLocalBit && hasKdfBit;
        return canUseDILData;
    }

    int dilLength() {
        return this.shareBytes().length - 86 - 16;
    }

    byte[] dilGetBytes(long pos, int length) throws SQLException {
        if (length == 0) {
            return new byte[0];
        }
        if (this.dilLength() == 0) {
            return null;
        }
        int lengthAvailable = (int)Math.min((long)length, (long)this.dilLength() - (pos - 1L));
        if (lengthAvailable <= 0) {
            return null;
        }
        byte[] result = new byte[lengthAvailable];
        System.arraycopy(this.shareBytes(), (int)(pos - 1L) + 86 + 16, result, 0, lengthAvailable);
        return result;
    }

    InputStream dilGetBinaryStream(long pos) throws SQLException {
        if (pos < 0L) {
            throw new IllegalArgumentException("Illegal Arguments");
        }
        byte[] dilBytes = this.dilGetBytes(pos, this.dilLength());
        if (dilBytes == null) {
            dilBytes = new byte[]{};
        }
        return new ByteArrayInputStream(dilBytes);
    }

    @Override
    public void freeLOB() throws SQLException {
        this.freeInternal();
    }

    @Override
    public void free() throws SQLException {
        this.awaitPublishing();
        this.freeInternal();
    }

    private void freeInternal() throws SQLException {
        if (this.isFree) {
            return;
        }
        BlobDBAccess myDBAccess = this.getDBAccess();
        try (Monitor.CloseableLock lock = myDBAccess.acquireCloseableLock();){
            if (this.isOpenLobInternal(myDBAccess)) {
                this.closeLobInternal(myDBAccess);
            }
            if (this.isTemporaryInternal(myDBAccess)) {
                this.freeTemporaryInternal(myDBAccess);
            }
        }
        this.getPhysicalConnection().removeLargeObject(this);
        this.isFree = true;
        this.dbaccess = null;
    }

    @Override
    public final Flow.Publisher<Void> freeAsyncOracle() throws SQLException {
        if (this.isFree) {
            return CompletionStageUtil.newNoItemPublisher(CompletionStageUtil.VOID_COMPLETED_FUTURE, this.getInternalConnection().getJoinPhaser());
        }
        this.lockBeforePublishing();
        return CompletionStageUtil.newNoItemPublisher(this.getDBAccess().isOpenLobAsync(this).thenCompose(isOpen -> isOpen != false ? this.dbaccess.closeLobAsync(this) : CompletionStageUtil.VOID_COMPLETED_FUTURE).thenRun(() -> {
            try {
                if (this.isTemporary()) {
                    this.freeTemporary();
                }
                this.getPhysicalConnection().removeLargeObject(this);
                this.isFree = true;
                this.dbaccess = null;
            }
            catch (SQLException sqlException) {
                throw new CompletionException(sqlException);
            }
        }), this.getInternalConnection().getJoinPhaser());
    }

    @Override
    public boolean isFree() {
        return this.isFree;
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.awaitPublishing();
        if (this.isFree) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 192).fillInStackTrace();
        }
        if (this.canReadBasicLobDataInLocator()) {
            return this.dilGetBinaryStream(pos, length);
        }
        long lobLen = this.length();
        if (pos < 1L || length < 0L || pos > lobLen || pos - 1L + length > lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        return this.getDBAccess().newInputStream((oracle.jdbc.internal.OracleBlob)this, this.getChunkSize(), pos, length);
    }

    InputStream dilGetBinaryStream(long pos, long length) throws SQLException {
        int lobLen = this.dilLength();
        if (pos < 1L || length < 0L || pos > (long)lobLen || pos - 1L + length > (long)lobLen) {
            throw (SQLException)DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68).fillInStackTrace();
        }
        byte[] dilBytes = this.dilGetBytes(pos, lobLen - (int)(pos - 1L));
        return new ByteArrayInputStream(dilBytes, 0, (int)length);
    }

    @Override
    public void setBytes(byte[] locator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setACProxy(Object w) {
        this.acProxy = w;
    }

    @Override
    public Object getACProxy() {
        return this.acProxy;
    }

    @Override
    public SQLXML toSQLXML() throws SQLException {
        this.awaitPublishing();
        return this.toSQLXML(this.getPhysicalConnection().getDbCsId());
    }

    @Override
    public SQLXML toSQLXML(int csid) throws SQLException {
        this.awaitPublishing();
        return null;
    }

    private final void lockBeforePublishing() throws SQLException {
        this.publishingLock.lock();
        this.awaitPublishing();
        try {
            this.isPublishing = true;
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void awaitPublishing() throws SQLException {
        this.publishingLock.lock();
        try {
            while (this.isPublishing) {
                this.publishingCondition.await();
            }
        }
        catch (InterruptedException interrupt) {
            throw new SQLException(interrupt);
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private final void unlockAfterPublishing() {
        this.publishingLock.lock();
        try {
            this.isPublishing = false;
            this.publishingCondition.signalAll();
        }
        finally {
            this.publishingLock.unlock();
        }
    }

    private static int computeBufferSize(int chunkSize) {
        if (chunkSize >= 32768 || chunkSize <= 0) {
            return 32768;
        }
        return 32768 / chunkSize * chunkSize;
    }
}

