/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.CollectionUDF;

import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class MVFindFunctionImpl
extends ImplementorUDF {
    public MVFindFunctionImpl() {
        super(new MVFindImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.INTEGER_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return UDFOperandMetadata.wrap(OperandTypes.family((SqlTypeFamily[])new SqlTypeFamily[]{SqlTypeFamily.ARRAY, SqlTypeFamily.CHARACTER}));
    }

    private static Integer mvfindCore(List<Object> array, Pattern pattern) {
        for (int i = 0; i < array.size(); ++i) {
            String strValue;
            Object element = array.get(i);
            if (element == null || !pattern.matcher(strValue = element.toString()).find()) continue;
            return i;
        }
        return null;
    }

    public static Integer evalWithPattern(List<Object> array, Pattern pattern) {
        if (array == null || pattern == null) {
            return null;
        }
        return MVFindFunctionImpl.mvfindCore(array, pattern);
    }

    public static Integer evalWithString(List<Object> array, String regex) {
        if (array == null || regex == null) {
            return null;
        }
        return MVFindFunctionImpl.mvfind(array, regex);
    }

    private static Integer mvfind(List<Object> array, String regex) {
        Pattern pattern;
        if (array == null || regex == null) {
            return null;
        }
        try {
            pattern = Pattern.compile(regex);
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid regex pattern '%s': %s", regex, e.getDescription()), e);
        }
        return MVFindFunctionImpl.mvfindCore(array, pattern);
    }

    public static class MVFindImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator translator, RexCall call, List<Expression> translatedOperands) {
            RexLiteral patternLiteral;
            Expression literalPatternExpr;
            Expression arrayExpr = translatedOperands.get(0);
            Expression patternExpr = translatedOperands.get(1);
            if (call.operands.size() >= 2 && call.operands.get(1) instanceof RexLiteral && (literalPatternExpr = MVFindImplementor.tryCompileLiteralPattern(patternLiteral = (RexLiteral)call.operands.get(1), arrayExpr)) != null) {
                return literalPatternExpr;
            }
            return Expressions.call((Method)Types.lookupMethod(MVFindFunctionImpl.class, (String)"evalWithString", (Class[])new Class[]{List.class, String.class}), (Expression[])new Expression[]{arrayExpr, patternExpr});
        }

        private static Expression tryCompileLiteralPattern(RexLiteral patternLiteral, Expression arrayExpr) {
            String patternString = (String)patternLiteral.getValueAs(String.class);
            if (patternString == null) {
                return null;
            }
            try {
                Pattern compiledPattern = Pattern.compile(patternString);
                return Expressions.call((Method)Types.lookupMethod(MVFindFunctionImpl.class, (String)"evalWithPattern", (Class[])new Class[]{List.class, Pattern.class}), (Expression[])new Expression[]{arrayExpr, Expressions.constant((Object)compiledPattern, Pattern.class)});
            }
            catch (PatternSyntaxException e) {
                throw new IllegalArgumentException(String.format("Invalid regex pattern '%s': %s", patternString, e.getDescription()), e);
            }
        }
    }
}

