"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BaseConnectionManager = void 0;
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * Generic query executor interface.
 * This allows overriding the query execution at runtime with custom implementations.
 * @template TParams The type of query parameters
 * @template TResponse The type of query response
 */

/**
 * @experimental this class is experimental and might change in future releases.
 * @template TClient The type of the underlying client
 * @template TQueryParams The type of query parameters (defaults to unknown)
 * @template TQueryResponse The type of query response (defaults to unknown)
 */
class BaseConnectionManager {
  constructor() {
    _defineProperty(this, "clientFactory", void 0);
    _defineProperty(this, "queryExecutor", void 0);
  }

  /**
   * Set the client factory for creating connection clients.
   * This allows overriding the default client behavior at runtime.
   */
  setClientFactory(factory) {
    this.clientFactory = factory;
  }

  /**
   * Set the query executor for query execution.
   * This allows overriding the default query behavior at runtime.
   */
  setQueryExecutor(executor) {
    this.queryExecutor = executor;
  }
  getQueryExecutor() {
    return this.queryExecutor;
  }
  getClient(context, request) {
    if (!this.clientFactory) {
      throw new Error('Client factory not set');
    }
    return this.clientFactory(context, request);
  }

  /**
   * Execute a query against the data source
   */
  async query(context, request, params) {
    if (!this.queryExecutor) {
      throw new Error('No query executor available');
    }
    return this.queryExecutor.execute(context, request, params);
  }
}
exports.BaseConnectionManager = BaseConnectionManager;