/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.crt.CRT;
import software.amazon.awssdk.crt.CrtPlatform;
import software.amazon.awssdk.crt.CrtRuntimeException;

public class ExtractLib {
    public static void extractLibrary(File extractFile) {
        try {
            String platformLibResourcePath;
            if (!extractFile.setExecutable(true, true)) {
                throw new CrtRuntimeException("Unable to make shared library executable by owner only");
            }
            if (!extractFile.setWritable(true, true)) {
                throw new CrtRuntimeException("Unable to make shared library writeable by owner only");
            }
            if (!extractFile.setReadable(true, true)) {
                throw new CrtRuntimeException("Unable to make shared library readable by owner only");
            }
            String libraryName = System.mapLibraryName("aws-crt-jni");
            String os = CRT.getOSIdentifier();
            String libResourcePath = "/" + os + "/" + CRT.getArchIdentifier() + "/" + CRT.getCRuntime(os) + "/" + libraryName;
            CrtPlatform platform = CRT.getPlatformImpl();
            if (platform != null && (platformLibResourcePath = platform.getResourcePath(CRT.getCRuntime(os), libraryName)) != null) {
                libResourcePath = platformLibResourcePath;
            }
            try (InputStream in = CRT.class.getResourceAsStream(libResourcePath);){
                if (in == null) {
                    throw new IOException("Unable to open library in jar for AWS CRT: " + libResourcePath);
                }
                try (FileOutputStream out = new FileOutputStream(extractFile);){
                    int read;
                    byte[] bytes = new byte[1024];
                    while ((read = in.read(bytes)) != -1) {
                        out.write(bytes, 0, read);
                    }
                }
            }
            if (!extractFile.setWritable(false)) {
                throw new CrtRuntimeException("Unable to make shared library read-only");
            }
        }
        catch (CrtRuntimeException crtex) {
            System.err.println("Unable to initialize AWS CRT: " + crtex);
            crtex.printStackTrace();
            throw crtex;
        }
        catch (CRT.UnknownPlatformException upe) {
            System.err.println("Unable to determine platform for AWS CRT: " + upe);
            upe.printStackTrace();
            CrtRuntimeException rex = new CrtRuntimeException("Unable to determine platform for AWS CRT");
            rex.initCause(upe);
            throw rex;
        }
        catch (Exception ex) {
            System.err.println("Unable to unpack AWS CRT lib: " + ex);
            ex.printStackTrace();
            CrtRuntimeException rex = new CrtRuntimeException("Unable to unpack AWS CRT library");
            rex.initCause(ex);
            throw rex;
        }
    }

    public static void extractLibrary(String path) {
        String libraryName = System.mapLibraryName("aws-crt-jni");
        File extractFile = new File(path, libraryName);
        try {
            extractFile.createNewFile();
        }
        catch (Exception ex) {
            CrtRuntimeException rex = new CrtRuntimeException("Unable to create file on path:" + extractFile.getAbsolutePath());
            rex.initCause(ex);
            throw rex;
        }
        ExtractLib.extractLibrary(extractFile);
    }
}

