/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.engine.analysis;

import ai.djl.Model;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Map;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.engine.MLEngine;

public class DJLUtils {
    private static MLEngine mlEngine;

    private static <T> T withDJLContext(Callable<T> action) throws PrivilegedActionException {
        return (T)AccessController.doPrivileged(() -> {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                System.setProperty("java.library.path", mlEngine.getMlCachePath().toAbsolutePath().toString());
                System.setProperty("DJL_CACHE_DIR", mlEngine.getMlCachePath().toAbsolutePath().toString());
                Thread.currentThread().setContextClassLoader(Model.class.getClassLoader());
                Object v = action.call();
                return v;
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        });
    }

    public static HuggingFaceTokenizer buildHuggingFaceTokenizer(Path resourcePath) {
        try {
            return DJLUtils.withDJLContext(() -> HuggingFaceTokenizer.newInstance((Path)resourcePath));
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException("Failed to initialize Hugging Face tokenizer. " + String.valueOf(e));
        }
    }

    public static Map<String, Float> fetchTokenWeights(Path resourcePath) {
        try {
            Type mapType = new TypeToken<Map<String, Float>>(){}.getType();
            return (Map)StringUtils.gson.fromJson((Reader)new InputStreamReader(Files.newInputStream(resourcePath, new OpenOption[0])), mapType);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to parse token weights file. " + String.valueOf(e));
        }
    }

    @Generated
    public static MLEngine getMlEngine() {
        return mlEngine;
    }

    @Generated
    public static void setMlEngine(MLEngine mlEngine) {
        DJLUtils.mlEngine = mlEngine;
    }
}

