/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cli;

import java.util.List;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DeprecatedAttributes;
import org.apache.commons.cli.Option;
import org.apache.solr.cli.SolrCLI;
import org.apache.solr.cli.ToolBase;
import org.apache.solr.cli.ToolRuntime;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.request.CollectionAdminRequest;

public class SnapshotExportTool
extends ToolBase {
    public SnapshotExportTool(ToolRuntime runtime) {
        super(runtime);
    }

    @Override
    public String getName() {
        return "snapshot-export";
    }

    @Override
    public List<Option> getOptions() {
        return List.of(SolrCLI.OPTION_ZKHOST, SolrCLI.OPTION_SOLRURL, SolrCLI.OPTION_SOLRURL_DEPRECATED_SHORT, Option.builder((String)"c").longOpt("name").argName("NAME").hasArg().required(true).desc("Name of collection to be snapshot.").build(), Option.builder().longOpt("snapshot-name").argName("NAME").hasArg().required(true).desc("Name of the snapshot to be exported.").build(), Option.builder().longOpt("dest-dir").argName("DIR").hasArg().required(true).desc("Path of a temporary directory on local filesystem during snapshot export command.").build(), Option.builder().longOpt("backup-repo-name").argName("DIR").hasArg().required(false).desc("Specifies name of the backup repository to be used during snapshot export preparation.").build(), Option.builder((String)"i").deprecated(DeprecatedAttributes.builder().setForRemoval(true).setSince("9.8").setDescription("Use --async-id instead").get()).argName("ID").hasArg().required(false).desc("Specifies the async request identifier to be used during snapshot export preparation.").build(), Option.builder().longOpt("async-id").argName("ID").hasArg().required(false).desc("Specifies the async request identifier to be used during snapshot export preparation.").build(), SolrCLI.OPTION_CREDENTIALS);
    }

    @Override
    public void runImpl(CommandLine cli) throws Exception {
        SolrCLI.raiseLogLevelUnlessVerbose(cli);
        String snapshotName = cli.getOptionValue("snapshot-name");
        String collectionName = cli.getOptionValue("name");
        String destDir = cli.getOptionValue("dest-dir");
        Optional<String> backupRepo = Optional.ofNullable(cli.getOptionValue("backup-repo-name"));
        Optional<String> asyncReqId = Optional.ofNullable(cli.getOptionValue("async-id"));
        if (cli.hasOption("i")) {
            asyncReqId = Optional.ofNullable(cli.getOptionValue("i"));
        }
        try (SolrClient solrClient = SolrCLI.getSolrClient(cli);){
            this.exportSnapshot(solrClient, collectionName, snapshotName, destDir, backupRepo, asyncReqId);
        }
    }

    public void exportSnapshot(SolrClient solrClient, String collectionName, String snapshotName, String destPath, Optional<String> backupRepo, Optional<String> asyncReqId) {
        try {
            CollectionAdminRequest.Backup backup = new CollectionAdminRequest.Backup(collectionName, snapshotName);
            backup.setCommitName(snapshotName);
            backup.setIndexBackupStrategy("copy-files");
            backup.setLocation(destPath);
            if (backupRepo.isPresent()) {
                backup.setRepositoryName(backupRepo.get());
            }
            backup.processAsync((String)asyncReqId.orElse(null), solrClient);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to backup collection meta-data for collection " + collectionName + " due to following error : " + e.getLocalizedMessage());
        }
    }
}

