/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.metrics;

import com.codahale.metrics.Clock;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;

public class DelegateRegistryTimer
extends Timer {
    private final Timer primaryTimer;
    private final Timer delegateTimer;
    private final Clock clock;

    public DelegateRegistryTimer(Clock clock, Timer primaryTimer, Timer delegateTimer) {
        this.primaryTimer = primaryTimer;
        this.delegateTimer = delegateTimer;
        this.clock = clock;
    }

    public void update(long duration, TimeUnit unit) {
        this.primaryTimer.update(duration, unit);
        this.delegateTimer.update(duration, unit);
    }

    public void update(Duration duration) {
        this.primaryTimer.update(duration);
        this.delegateTimer.update(duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T time(Callable<T> event) throws Exception {
        long startTime = this.clock.getTick();
        try {
            T t = event.call();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T timeSupplier(Supplier<T> event) {
        long startTime = this.clock.getTick();
        try {
            T t = event.get();
            return t;
        }
        finally {
            this.update(this.clock.getTick() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void time(Runnable event) {
        long startTime = this.clock.getTick();
        try {
            event.run();
        }
        finally {
            this.update(this.clock.getTick() - startTime, TimeUnit.NANOSECONDS);
        }
    }

    public Timer.Context time() {
        return super.time();
    }

    public long getCount() {
        return this.primaryTimer.getCount();
    }

    public double getFifteenMinuteRate() {
        return this.primaryTimer.getFifteenMinuteRate();
    }

    public double getFiveMinuteRate() {
        return this.primaryTimer.getFiveMinuteRate();
    }

    public double getMeanRate() {
        return this.primaryTimer.getMeanRate();
    }

    public double getOneMinuteRate() {
        return this.primaryTimer.getOneMinuteRate();
    }

    public Snapshot getSnapshot() {
        return this.primaryTimer.getSnapshot();
    }

    public Timer getPrimaryTimer() {
        return this.primaryTimer;
    }

    public Timer getDelegateTimer() {
        return this.delegateTimer;
    }
}

