/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.chm.lzx;

import java.math.BigInteger;
import java.util.Arrays;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.parser.chm.core.ChmCommons;

public class ChmSection {
    private final byte[] data;
    private final byte[] prevcontent;
    private int swath;
    private int total;
    private int buffer;

    public ChmSection(byte[] data) throws TikaException {
        this(data, null);
    }

    public ChmSection(byte[] data, byte[] prevconent) throws TikaException {
        ChmCommons.assertByteArrayNotNull(data);
        this.data = data;
        this.prevcontent = prevconent;
    }

    public byte[] reverseByteOrder(byte[] toBeReversed) throws TikaException {
        ChmCommons.assertByteArrayNotNull(toBeReversed);
        ChmCommons.reverse(toBeReversed);
        return toBeReversed;
    }

    public int checkBit(int i) {
        return (this.getBuffer() & 1 << this.getTotal() - i) == 0 ? 0 : 1;
    }

    public int getSyncBits(int bit) {
        return this.getDesyncBits(bit, bit);
    }

    public int peekBits(int bit) {
        return this.getDesyncBits(bit, 0);
    }

    private int getDesyncBits(int bit, int removeBit) {
        while (this.getTotal() < 16) {
            this.setBuffer((this.getBuffer() << 16) + this.unmarshalUByte() + (this.unmarshalUByte() << 8));
            this.setTotal(this.getTotal() + 16);
        }
        int tmp = this.getBuffer() >>> this.getTotal() - bit;
        this.setTotal(this.getTotal() - removeBit);
        this.setBuffer(this.getBuffer() - (this.getBuffer() >>> this.getTotal() << this.getTotal()));
        return tmp;
    }

    public int unmarshalUByte() {
        return this.getByte() & 0xFF;
    }

    public byte getByte() {
        if (this.getSwath() < this.getData().length) {
            this.setSwath(this.getSwath() + 1);
            return this.getData()[this.getSwath() - 1];
        }
        return 0;
    }

    public int getLeft() {
        return this.getData().length - this.getSwath();
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] getPrevContent() {
        return this.prevcontent;
    }

    public BigInteger getBigInteger(int i) throws TikaException {
        if (i > 8) {
            throw new TikaMemoryLimitException("Big integer can't be > 8");
        }
        if (this.getData() == null) {
            return BigInteger.ZERO;
        }
        if (this.getData().length - this.getSwath() < i) {
            i = this.getData().length - this.getSwath();
        }
        byte[] tmp = new byte[i];
        for (int j = i - 1; j >= 0; --j) {
            tmp[i - j - 1] = this.getData()[this.getSwath() + j];
        }
        this.setSwath(this.getSwath() + i);
        return new BigInteger(tmp);
    }

    public byte[] stringToAsciiBytes(String s) {
        char[] c = s.toCharArray();
        byte[] byteval = new byte[c.length];
        for (int i = 0; i < c.length; ++i) {
            byteval[i] = (byte)c[i];
        }
        return byteval;
    }

    public int unmarshalInt() throws TikaException {
        return this.getBigInteger(4).intValue();
    }

    public byte[] unmarshalBytes(int i) {
        if (i == 0) {
            return new byte[1];
        }
        byte[] t = new byte[i];
        for (int j = 0; j < i; ++j) {
            t[j] = this.getData()[j + this.getSwath()];
        }
        this.setSwath(this.getSwath() + i);
        return t;
    }

    public BigInteger getEncint() {
        byte ob;
        BigInteger bi = BigInteger.ZERO;
        byte[] nb = new byte[1];
        while ((ob = this.getByte()) < 0) {
            nb[0] = (byte)(ob & 0x7F);
            bi = bi.shiftLeft(7).add(new BigInteger(nb));
        }
        nb[0] = (byte)(ob & 0x7F);
        bi = bi.shiftLeft(7).add(new BigInteger(nb));
        return bi;
    }

    public char unmarshalUtfChar() {
        int j;
        int i = 1;
        byte ob = this.getByte();
        if (ob < 0) {
            i = 2;
            while (ob << 24 + i < 0) {
                ++i;
            }
        }
        byte[] ba = new byte[i];
        ba[0] = ob;
        for (j = 1; j < i; ++j) {
            ba[j] = this.getByte();
        }
        i = ba.length;
        if (i == 1) {
            return (char)ba[0];
        }
        int n = ba[0] & 0xF;
        j = 1;
        while (j < i) {
            n = (n << 6) + (ba[j++] & 0x3F);
        }
        return (char)n;
    }

    public int getSwath() {
        return this.swath;
    }

    public void setSwath(int swath) {
        this.swath = swath;
    }

    public int getTotal() {
        return this.total;
    }

    public void setTotal(int total) {
        this.total = total;
    }

    private int getBuffer() {
        return this.buffer;
    }

    private void setBuffer(int buffer) {
        this.buffer = buffer;
    }

    public static void main(String[] args) throws TikaException {
        byte[] array = new byte[]{4, 78, -67, 90, 1, -33};
        ChmSection chmSection = new ChmSection(array);
        System.out.println("before " + Arrays.toString(array));
        System.out.println("after " + Arrays.toString(chmSection.reverseByteOrder(array)));
    }
}

