/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.PickCone;
import javax.media.j3d.PickCylinder;
import javax.media.j3d.PickShape;
import javax.media.j3d.Transform3D;
import javax.media.j3d.Utils;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public final class PickConeSegment
extends PickCone {
    Point3d end;

    public PickConeSegment() {
        this.end = new Point3d();
    }

    public PickConeSegment(Point3d point3d, Point3d point3d2, double d) {
        this.origin = new Point3d(point3d);
        this.end = new Point3d(point3d2);
        this.direction = new Vector3d();
        this.spreadAngle = d;
        this.calcDirection();
    }

    public void set(Point3d point3d, Point3d point3d2, double d) {
        this.origin.set((Tuple3d)point3d);
        this.end.set((Tuple3d)point3d2);
        this.spreadAngle = d;
        this.calcDirection();
    }

    public void getEnd(Point3d point3d) {
        point3d.set((Tuple3d)this.end);
    }

    private void calcDirection() {
        this.direction.x = this.end.x - this.origin.x;
        this.direction.y = this.end.y - this.origin.y;
        this.direction.z = this.end.z - this.origin.z;
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d point4d) {
        Point4d point4d2 = new Point4d();
        Vector3d vector3d = new Vector3d();
        Point3d point3d = new Point3d();
        if (bounds instanceof BoundingSphere) {
            Point3d point3d2 = ((BoundingSphere)bounds).getCenter();
            double d = ((BoundingSphere)bounds).getRadius();
            double d2 = Utils.ptToSegSquare(point3d2, this.origin, this.end, point3d);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d3 = vector3d.length();
            double d4 = this.getRadius(d3);
            return d2 <= (d + d4) * (d + d4);
        }
        if (bounds instanceof BoundingBox) {
            Point3d point3d3 = new Point3d();
            ((BoundingBox)bounds).getLower(point3d3);
            Point3d point3d4 = ((BoundingBox)bounds).getCenter();
            double d = Utils.ptToSegSquare(point3d4, this.origin, this.end, point3d);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d5 = vector3d.length();
            double d6 = this.getRadius(d5);
            double d7 = point3d4.x - point3d3.x + d6;
            double d8 = d7 * d7;
            d7 = point3d4.y - point3d3.y + d6;
            d8 += d7 * d7;
            d7 = point3d4.z - point3d3.z + d6;
            d8 += d7 * d7;
            if (d > d8) {
                return false;
            }
            if (d < d6 * d6) {
                return true;
            }
            if (((BoundingBox)bounds).intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            Point3d point3d5 = new Point3d();
            ((BoundingBox)bounds).getUpper(point3d5);
            Point3d[][] point3dArrayArray = new Point3d[][]{{point3d5, new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d5.z), new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d3.y, point3d5.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d5.z), point3d5}, {point3d3, new Point3d(point3d3.x, point3d5.y, point3d3.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d3.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d3.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), point3d3}, {point3d3, new Point3d(point3d3.x, point3d3.y, point3d5.z)}, {new Point3d(point3d3.x, point3d5.y, point3d3.z), new Point3d(point3d3.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d5.y, point3d3.z), new Point3d(point3d5.x, point3d5.y, point3d5.z)}, {new Point3d(point3d5.x, point3d3.y, point3d3.z), new Point3d(point3d5.x, point3d3.y, point3d5.z)}};
            for (int i = 0; i < point3dArrayArray.length; ++i) {
                double d9 = Utils.segmentToSegment(this.origin, this.end, point3dArrayArray[i][0], point3dArrayArray[i][1], point3d, null, null);
                vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
                d5 = vector3d.length();
                d6 = this.getRadius(d5);
                if (!(d9 <= d6 * d6)) continue;
                return true;
            }
            return false;
        }
        if (bounds instanceof BoundingPolytope) {
            Point3d point3d6 = new Point3d();
            BoundingSphere boundingSphere = new BoundingSphere(bounds);
            boundingSphere.getCenter(point3d6);
            double d = boundingSphere.getRadius();
            double d10 = Utils.ptToSegSquare(point3d6, this.origin, this.end, point3d);
            vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
            double d11 = vector3d.length();
            double d12 = this.getRadius(d11);
            if (d10 > (d + d12) * (d + d12)) {
                return false;
            }
            if (bounds.intersect(this.origin, this.direction, point4d2)) {
                return true;
            }
            BoundingPolytope boundingPolytope = (BoundingPolytope)bounds;
            Point3d point3d7 = new Point3d();
            for (int i = 0; i < boundingPolytope.nVerts; ++i) {
                int n = i;
                while (i < boundingPolytope.nVerts) {
                    point3d7.x = (boundingPolytope.verts[i].x + boundingPolytope.verts[n].x) * 0.5;
                    point3d7.y = (boundingPolytope.verts[i].y + boundingPolytope.verts[n].y) * 0.5;
                    point3d7.z = (boundingPolytope.verts[i].z + boundingPolytope.verts[n].z) * 0.5;
                    if (PickCylinder.pointInPolytope(boundingPolytope, point3d7.x, point3d7.y, point3d7.z)) {
                        double d13 = Utils.segmentToSegment(this.origin, this.end, boundingPolytope.verts[i], boundingPolytope.verts[n], point3d, null, null);
                        vector3d.sub((Tuple3d)point3d, (Tuple3d)this.origin);
                        d11 = vector3d.length();
                        d12 = this.getRadius(d11);
                        if (d13 <= d12 * d12) {
                            return true;
                        }
                    }
                    ++i;
                }
            }
            return false;
        }
        return false;
    }

    @Override
    PickShape transform(Transform3D transform3D) {
        PickConeSegment pickConeSegment = new PickConeSegment();
        pickConeSegment.origin.x = this.origin.x;
        pickConeSegment.origin.y = this.origin.y;
        pickConeSegment.origin.z = this.origin.z;
        pickConeSegment.spreadAngle = this.spreadAngle;
        pickConeSegment.end.x = this.end.x;
        pickConeSegment.end.y = this.end.y;
        pickConeSegment.end.z = this.end.z;
        transform3D.transform(pickConeSegment.origin);
        transform3D.transform(pickConeSegment.end);
        pickConeSegment.direction.x = pickConeSegment.end.x - pickConeSegment.origin.x;
        pickConeSegment.direction.y = pickConeSegment.end.y - pickConeSegment.origin.y;
        pickConeSegment.direction.z = pickConeSegment.end.z - pickConeSegment.origin.z;
        pickConeSegment.direction.normalize();
        return pickConeSegment;
    }
}

