/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.rfb;

import com.tigervnc.rdr.InStream;
import com.tigervnc.rdr.OutStream;
import com.tigervnc.rfb.Decoder;
import com.tigervnc.rfb.LogWriter;
import com.tigervnc.rfb.ModifiablePixelBuffer;
import com.tigervnc.rfb.Rect;
import com.tigervnc.rfb.ServerParams;

public class RawDecoder
extends Decoder {
    static LogWriter vlog = new LogWriter("RawDecoder");

    public RawDecoder() {
        super(Decoder.DecoderFlags.DecoderPlain);
    }

    @Override
    public void readRect(Rect rect, InStream inStream, ServerParams serverParams, OutStream outStream) {
        outStream.copyBytes(inStream, rect.area() * serverParams.pf().bpp / 8);
    }

    @Override
    public void decodeRect(Rect rect, Object object, int n, ServerParams serverParams, ModifiablePixelBuffer modifiablePixelBuffer) {
        assert (n >= rect.area() * serverParams.pf().bpp / 8);
        modifiablePixelBuffer.imageRect(serverParams.pf(), rect, (byte[])object);
    }
}

