/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.Curve;

public final class Edge {
    Curve curve;
    int ctag;
    int etag;
    double activey;
    int equivalence;
    private Edge lastEdge;
    private int lastResult;
    private double lastLimit;

    public Edge(Curve curve, int n) {
        this(curve, n, 0);
    }

    public Edge(Curve curve, int n, int n2) {
        this.curve = curve;
        this.ctag = n;
        this.etag = n2;
    }

    public Curve getCurve() {
        return this.curve;
    }

    public int getCurveTag() {
        return this.ctag;
    }

    public int getEdgeTag() {
        return this.etag;
    }

    public void setEdgeTag(int n) {
        this.etag = n;
    }

    public int getEquivalence() {
        return this.equivalence;
    }

    public void setEquivalence(int n) {
        this.equivalence = n;
    }

    public int compareTo(Edge edge, double[] dArray) {
        if (edge == this.lastEdge && dArray[0] < this.lastLimit) {
            if (dArray[1] > this.lastLimit) {
                dArray[1] = this.lastLimit;
            }
            return this.lastResult;
        }
        if (this == edge.lastEdge && dArray[0] < edge.lastLimit) {
            if (dArray[1] > edge.lastLimit) {
                dArray[1] = edge.lastLimit;
            }
            return 0 - edge.lastResult;
        }
        int n = this.curve.compareTo(edge.curve, dArray);
        this.lastEdge = edge;
        this.lastLimit = dArray[1];
        this.lastResult = n;
        return n;
    }

    public void record(double d, int n) {
        this.activey = d;
        this.etag = n;
    }

    public boolean isActiveFor(double d, int n) {
        return this.etag == n && this.activey >= d;
    }

    public String toString() {
        return "Edge[" + this.curve + ", " + (this.ctag == 0 ? "L" : "R") + ", " + (this.etag == 1 ? "I" : (this.etag == -1 ? "O" : "N")) + "]";
    }
}

