import fsp from 'fs/promises';
import addrs from "email-addresses";
const verbose = !!process.env['VERBOSE'];
async function tryReadHeader(mdHeadFile) {
    try {
        return [await fsp.readFile(mdHeadFile, 'utf-8')];
    }
    catch (err) {
        if (verbose) {
            console.error(err);
        }
        return [];
    }
}
function pushTableRowIfTruthy(lines, label, value) {
    if (value) {
        lines.push(`| ${label} | ${value} |`);
    }
}
function findFirstWithChild(profiles, key) {
    return profiles.find(p => !!p[key])?.[key];
}
function printEmail(email) {
    if (!email) {
        return email;
    }
    const addr = addrs.parseOneAddress(email)?.['address'];
    return `[${email.replaceAll('<', '&lt;').replaceAll('>', '&gt;')}](mailto:${addr})`;
}
export async function generateMirrorMd(mdHeadFile, mirrorProfilesByMirrorName) {
    const lines = await tryReadHeader(mdHeadFile);
    lines.push('# Mirrors\n\nContact or other information for the mirrors of our repositories and ISOs.\n');
    for (let mirrorName in mirrorProfilesByMirrorName) {
        const profiles = mirrorProfilesByMirrorName[mirrorName];
        const activeProfiles = profiles.filter(p => p.active);
        const urls = profiles.map(p => {
            const url = p.url.split('$repo')[0];
            return p.active ? url : `${url} (inactive)`;
        });
        const upstream = findFirstWithChild(activeProfiles, 'upstream');
        lines.push(`### ${mirrorName}`);
        lines.push(`| Mirror | ${mirrorName} |`);
        lines.push('| ------ | ------------- |');
        if (upstream) {
            lines.push(`| Sync Source | [${upstream}](#${upstream.replaceAll('.', '')}) |`);
        }
        lines.push(`| URLs | ${urls.join('<br>')} |`);
        pushTableRowIfTruthy(lines, 'Provides Stable ISO', findFirstWithChild(activeProfiles, 'stable_isos'));
        pushTableRowIfTruthy(lines, 'Provides Weekly ISO', findFirstWithChild(activeProfiles, 'weekly_isos'));
        // pushTableRowIfTruthy(lines, 'Bandwidth', findFirstWithChild(activeProfiles, 'bandwidth'));
        // pushTableRowIfTruthy(lines, 'Frequency', findFirstWithChild(activeProfiles, 'frequency'));
        // pushTableRowIfTruthy(lines, 'Hosted by', findFirstWithChild(activeProfiles, 'org'));
        pushTableRowIfTruthy(lines, 'Location', findFirstWithChild(activeProfiles, 'country') || findFirstWithChild(profiles, 'country'));
        pushTableRowIfTruthy(lines, 'Contact Details', printEmail(findFirstWithChild(activeProfiles, 'admin_email') || findFirstWithChild(profiles, 'admin_email')));
        pushTableRowIfTruthy(lines, 'Altenate Contact Details', printEmail(findFirstWithChild(activeProfiles, 'alternate_email') || findFirstWithChild(profiles, 'alternate_email')));
        lines.push('');
    }
    return lines.join('\n');
}
export default generateMirrorMd;
//# sourceMappingURL=markdown.js.map