/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.rm;

import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.app.DBPProject;

public enum RMProjectType {
    GLOBAL("g"),
    SHARED("s"),
    USER("u");

    private final String prefix;

    private RMProjectType(String prefix) {
        this.prefix = prefix;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public static RMProjectType getByPrefix(@NotNull String prefix) {
        for (RMProjectType value : RMProjectType.values()) {
            if (!value.getPrefix().equals(prefix)) continue;
            return value;
        }
        return USER;
    }

    public static String getPlainProjectId(DBPProject project) {
        char typeC;
        String id = project.getId();
        if (id.length() > 2 && id.charAt(1) == '_' && ((typeC = id.charAt(0)) == 'g' || typeC == 's' || typeC == 'u')) {
            return id.substring(2);
        }
        return id;
    }
}

