# apparmor.d - Full set of apparmor profiles
# Copyright (C) 2021 Mikhail Morfikov
# Copyright (C) 2021-2024 Alexandre Pujol <alexandre@pujol.io>
# SPDX-License-Identifier: GPL-2.0-only

abi <abi/4.0>,

include <tunables/global>

@{exec_path}  = @{bin}/font-manager
@{att} = ""
profile font-manager /{,usr/}bin/font-manager {
  include <abstractions/base-strict>
  include <abstractions/dconf-write>
  include <abstractions/desktop>
  include <abstractions/fontconfig-cache-write>
  include <abstractions/gstreamer>
  include <abstractions/nameservice-strict>
  include <abstractions/ssl_certs>

  network inet dgram,
  network inet6 dgram,
  network inet stream,
  network inet6 stream,
  network netlink raw,

  @{exec_path} r,

  @{lib}/{,@{multiarch}/}webkit{2,}gtk-*/WebKitNetworkProcess rix,
  @{lib}/{,@{multiarch}/}webkit{2,}gtk-*/WebKitWebProcess rix,

  owner @{user_cache_dirs}/ rw,
  owner @{user_cache_dirs}/font-manager/ rw,
  owner @{user_cache_dirs}/font-manager/* rwk,

  owner @{user_config_dirs}/font-manager/ rw,
  owner @{user_config_dirs}/font-manager/* rw,

  owner @{user_config_dirs}/fontconfig/ rw,
  owner @{user_config_dirs}/fontconfig/conf.d/ rw,
  owner @{user_config_dirs}/fontconfig/conf.d/* rw,

  owner @{user_share_dirs}/fonts/ rw,
  owner "@{user_share_dirs}/fonts/Google Fonts/" rw,
  owner "@{user_share_dirs}/fonts/Google Fonts/**" rw,

  owner @{user_share_dirs}/ r,

  @{sys}/devices/virtual/dmi/id/chassis_type r,
  @{sys}/firmware/acpi/pm_profile r,
  @{sys}/fs/cgroup/{,**} r,

        @{PROC}/zoneinfo r,
  owner @{PROC}/@{pid}/cgroup r,
  owner @{PROC}/@{pid}/cmdline r,
  owner @{PROC}/@{pid}/fd/ r,
  owner @{PROC}/@{pid}/smaps r,
  owner @{PROC}/@{pid}/statm r,

  deny @{user_share_dirs}/gvfs-metadata/{,*} r,

  include if exists <local/font-manager>
}

# vim:syntax=apparmor
