# Print an optspec for argparse to handle cmd's options that are independent of any subcommand.
function __fish_bcachefs_global_optspecs
	string join \n h/help
end

function __fish_bcachefs_needs_command
	# Figure out if the current invocation already has a command.
	set -l cmd (commandline -opc)
	set -e cmd[1]
	argparse -s (__fish_bcachefs_global_optspecs) -- $cmd 2>/dev/null
	or return
	if set -q argv[1]
		# Also print the command, so this can be used to figure out what it is.
		echo $argv[1]
		return 1
	end
	return 0
end

function __fish_bcachefs_using_subcommand
	set -l cmd (__fish_bcachefs_needs_command)
	test -z "$cmd"
	and return 1
	contains -- $cmd[1] $argv
end

complete -c bcachefs -n "__fish_bcachefs_needs_command" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "subvol" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-file-option" -d 'Set attributes on files in a bcachefs filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reflink-option-propagate" -d 'Propagate IO options to reflinked extents'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reset-counters" -d 'Reset filesystem counters'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "version" -d 'Display version'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "data" -d 'Manage filesystem data'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "device" -d 'Manage devices within a filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "dump" -d 'Dump filesystem metadata to a qcow2 image'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "format" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "mkfs" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "fs" -d 'Manage a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "fsck" -d 'Check an existing filesystem for errors'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "image" -d 'Filesystem image commands'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "kill_btree_node" -d 'Kill a specific btree node (debugging)'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "list_journal" -d 'List filesystem journal entries'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "migrate" -d 'Migrate an existing ext2/3/4 filesystem to bcachefs in place'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "migrate-superblock" -d 'Create default superblock after migrating'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "reconcile" -d 'Reconcile filesystem data'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "recover-super" -d 'Attempt to recover overwritten superblock from backups'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "recovery-pass" -d 'List and manage scheduled recovery passes'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-fs-option" -d 'Set a filesystem option'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "set-passphrase" -d 'Change passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "remove-passphrase" -d 'Remove passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "show-super" -d 'Print superblock information to stdout'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "unlock" -d 'Unlock an encrypted filesystem prior to running/mounting'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "strip-alloc" -d 'Strip alloc info on a filesystem to be used read-only'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "undump" -d 'Convert qcow2 dump files back to raw device images'
complete -c bcachefs -n "__fish_bcachefs_needs_command" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s m -l mode -r -f -a "{keys\t'',formats\t'',nodes\t'',nodes-ondisk\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s b -l btree -d 'Btree to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s k -l bkey-type -d 'Bkey type to list' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s l -l level -d 'Btree depth to descend to (0 == leaves)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s s -l start -d 'Start position to list from' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s e -l end -d 'End position' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s c -l colorize -d 'Force color on/off. Default: autodetect tty' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s f -l fsck -d 'Check (fsck) the filesystem first'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s f -l passphrase-file -d 'Path to passphrase file' -r -F
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s k -l key_location -d 'Passphrase policy to use in case of an encrypted filesystem. If not specified, the password will be searched for in the keyring. If not found, the password will be prompted or read from stdin, depending on whether the stdin is connected to a terminal or not' -r -f -a "{fail\t'Don\'t ask for passphrase, if the key cannot be found in the keyring just fail',wait\t'Wait for passphrase to become available before mounting',ask\t'Interactively prompt the user for a passphrase',stdin\t'Try to read the passphrase from `stdin` without prompting'}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s o -d 'Mount options' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s t -l type -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s c -l colorize -d 'Force color on/off. Autodetect tty is used to define default:' -r -f -a "{true\t'',false\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mount" -s V -l version -d 'Print version'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand completions" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "create" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "new" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "delete" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "del" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snapshot" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snap" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snapshots" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from ls-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from list-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "snapshot" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "list" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvolume; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "create" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "new" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "delete" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "del" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snapshot" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "snap" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "ls-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "list-snap" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and not __fish_seen_subcommand_from create new delete del snapshot snap list ls list-snapshots ls-snap list-snap help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from new" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from delete" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from del" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snapshot" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s r -l read-only -d 'Make snapshot read only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l sort -d 'Sort order' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s t -l tree -d 'Show subvolume tree structure (implies -R)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s R -l recursive -d 'List subvolumes recursively'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s s -l snapshots -d 'Include snapshot subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -l readonly -d 'Only show read-only subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snapshots" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from ls-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l sort -d 'Sort order (flat view only)' -r -f -a "{name\t'',size\t'',time\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -s f -l flat -d 'Show flat list instead of tree'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l json -d 'Output as JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -l readonly -d 'Only show read-only snapshots (flat view only)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from list-snap" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "delete" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "snapshot" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "list" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand subvol; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l data_replicas -l data-replicas -d 'Number of data replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l data_checksum -l data-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l background_compression -l background-compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l foreground_target -l foreground-target -d 'Device or label for foreground writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l background_target -l background-target -d 'Device or label to move data to in the background' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l promote_target -l promote-target -d 'Device or label to promote data to on read' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l erasure_code -l erasure-code -d 'Enable erasure coding (DO NOT USE YET)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l casefold -d 'Dirent lookups are casefolded' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l inodes_32bit -l inodes-32bit -d 'Constrain inode numbers to 32 bits' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l project -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l nocow -d 'Nocow mode: Writes will be done in place when possible. Snapshots and reflink will still caused writes to be COW Implicitly disables data checksumming, compression and encryption' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -l remove-all -d 'Remove all file options'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-file-option" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reflink-option-propagate" -l set-may-update -d 'Enable option propagation on old reflink_p extents that predate the may_update_options flag. Requires CAP_SYS_ADMIN. Only needed once per file for filesystems with reflinks created before the flag was introduced.'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reflink-option-propagate" -s h -l help -d 'Print help (see more with \'--help\')'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reset-counters" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand version" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and not __fish_seen_subcommand_from scrub help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from scrub" -s m -l metadata -d 'Check metadata only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from scrub" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from help" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand data; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "add" -d 'Add a new device to an existing filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and not __fish_seen_subcommand_from add online offline remove evacuate set-state resize resize-journal help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l block_size -l block-size -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l btree_node_size -l btree-node-size -d 'Btree node size, default 256k' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l errors -d 'Action to take on filesystem error' -r -f -a "{continue\t'',fix_safe\t'',panic\t'',ro\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l write_error_timeout -l write-error-timeout -d 'Number of consecutive write errors allowed before kicking out a device' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l metadata_replicas -l metadata-replicas -d 'Number of metadata replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l data_replicas -l data-replicas -d 'Number of data replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l encoded_extent_max -l encoded-extent-max -d 'Maximum size of checksummed/compressed extents' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l metadata_checksum -l metadata-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l data_checksum -l data-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l checksum_err_retry_nr -l checksum-err-retry-nr -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l background_compression -l background-compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l str_hash -l str-hash -d 'Hash function for directory entries and xattrs' -r -f -a "{crc32c\t'',crc64\t'',siphash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l metadata_target -l metadata-target -d 'Device or label for metadata writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l foreground_target -l foreground-target -d 'Device or label for foreground writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l background_target -l background-target -d 'Device or label to move data to in the background' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l promote_target -l promote-target -d 'Device or label to promote data to on read' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l erasure_code -l erasure-code -d 'Enable erasure coding (DO NOT USE YET)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l casefold -d 'Dirent lookups are casefolded' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l inodes_32bit -l inodes-32bit -d 'Constrain inode numbers to 32 bits' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l shard_inode_numbers_bits -l shard-inode-numbers-bits -d 'Shard new inode numbers by CPU id' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l gc_reserve_percent -l gc-reserve-percent -d 'Percentage of disk space to reserve for copygc' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l gc_reserve_bytes -l gc-reserve-bytes -d 'Amount of disk space to reserve for copygc Takes precedence over gc_reserve_percent if set' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l root_reserve_percent -l root-reserve-percent -d 'Percentage of disk space to reserve for superuser' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l wide_macs -l wide-macs -d 'Store full 128 bits of cryptographic MACs, instead of 80' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l acl -d 'Enable POSIX acls' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l usrquota -d 'Enable user quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l grpquota -d 'Enable group quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l prjquota -d 'Enable project quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l journal_transaction_names -l journal-transaction-names -d 'Log transaction function names in journal' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l allocator_stuck_timeout -l allocator-stuck-timeout -d 'Default timeout in seconds for stuck allocator messages' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l nocow -d 'Nocow mode: Writes will be done in place when possible. Snapshots and reflink will still caused writes to be COW Implicitly disables data checksumming, compression and encryption' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l state -d 'rw,ro,failed,spare' -r -f -a "{rw\t'',ro\t'',evacuating\t'',spare\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l bucket_size -l bucket-size -d 'Specifies the bucket size; must be greater than the btree node size' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l durability -d 'Data written to this device will be considered to have already been replicated n times' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l data_allowed -l data-allowed -d 'Allowed data types for this device: journal, btree, and/or user' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l discard -d 'Enable discard/TRIM support' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -l rotational -d 'Disk is rotational; different behaviour for reconcile' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -s l -l label -d 'Disk label' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -s f -l force -d 'Use device even if it appears to already be formatted'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from add" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from online" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from offline" -s f -l force -d 'Force, if data redundancy will be degraded'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from offline" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s f -l force -d 'Force removal, even if some data couldn\'t be migrated'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s F -l force-metadata -d 'Force removal, even if some metadata couldn\'t be migrated'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from remove" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from evacuate" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s f -l force -d 'Force if data redundancy will be degraded'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s F -l force-if-data-lost -d 'Force even if data will be lost'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s o -l offline -d 'Set state of an offline device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from set-state" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from resize" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from resize-journal" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "add" -d 'Add a new device to an existing filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand device; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s o -d 'Output filename (without .qcow2 extension)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s s -l sanitize -d 'Sanitize inline data and optionally filenames (data or filenames)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s f -l force -d 'Force; overwrite existing files'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -l nojournal -d 'Don\'t dump entire journal, just dirty entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -l noexcl -d 'Open devices without O_EXCL'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s v -l verbose -d 'Verbose output'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand dump" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand format" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand mkfs" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "timestats" -d 'Display bcachefs time statistics'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and not __fish_seen_subcommand_from usage top timestats help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s f -l fields -d 'Comma-separated list of fields' -r -f -a "{replicas\t'',btree\t'',compression\t'',rebalance_work\t'',devices\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s a -l all -d 'Print all accounting fields'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from usage" -s h -l human-readable -d 'Human-readable units'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from top" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from top" -s h -l human-readable -d 'Human-readable units'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s s -l sort -d 'Sort by column' -r -f -a "{name\t'',count\t'',dur-min\t'',dur-max\t'',dur-total\t'',mean-since\t'',mean-recent\t'',stddev-since\t'',stddev-recent\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s i -l interval -d 'Refresh interval in seconds (interactive mode)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s a -l all -d 'Show stats with zero count'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l json -d 'Output raw JSON'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l no-device-stats -d 'Skip per-device IO latency stats'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -l once -d 'One-shot output (no interactive TUI)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from timestats" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "timestats" -d 'Display bcachefs time statistics'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fs; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s o -d 'Additional mount options' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s p -d 'Automatic repair (no questions)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s n -d 'Don\'t repair, only check for errors'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s y -d 'Assume "yes" to all questions'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s f -d 'Force checking even if filesystem is marked clean'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s r -l ratelimit_errors -d 'Don\'t display more than 10 errors of a given type'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s k -l kernel -d 'Use the in-kernel fsck implementation'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s K -l no-kernel -d 'Don\'t use the in-kernel fsck implementation'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s v -d 'Be verbose'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand fsck" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and not __fish_seen_subcommand_from create update help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and not __fish_seen_subcommand_from create update help" -f -a "create" -d 'Create a filesystem image'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and not __fish_seen_subcommand_from create update help" -f -a "update" -d 'Update a filesystem image, minimizing changes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and not __fish_seen_subcommand_from create update help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from create" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from update" -s s -l source -d 'Source directory' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from update" -s a -l keep-alloc -d 'Include allocation info in the filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from update" -s q -l quiet -d 'Only print errors'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from update" -s v -l verbose -d 'Verbose filesystem initialization'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from update" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from help" -f -a "create" -d 'Create a filesystem image'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from help" -f -a "update" -d 'Update a filesystem image, minimizing changes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand image; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand kill_btree_node" -s n -l node -d 'Node to kill (btree:level:idx)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand kill_btree_node" -s d -l dev -d 'Device index (default: kill all replicas)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand kill_btree_node" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s n -l nr-entries -d 'Number of journal entries to print' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s s -l seq -d 'Sequence number or range (seq or seq..seq)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s b -l btree -d 'Filter by btree (+/-btree1,btree2)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s t -l transaction -d 'Filter transactions by function (+/-fn1,fn2)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s k -l key -d 'Filter by key range (+/-bbpos[-bbpos],...)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s V -l bkey-val -d 'Print bkey values (true/false)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s a -l all -d 'Read entire journal, not just contiguous entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s d -l dirty-only -d 'Only read dirty entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s B -l blacklisted -d 'Include blacklisted entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s F -l flush-only -d 'Only flush entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s D -l datetime -d 'Datetime entries only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s H -l headers-only -d 'Headers only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -l all-headers -d 'Print all headers even if no transactions matched'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s l -l log -d 'Include log-only entries when filtering'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s L -l log-only -d 'Only print transactions containing log messages'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s o -l offset -d 'Print offset of each subentry'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s v -l verbose -d 'Verbose mode'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand list_journal" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand migrate" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand migrate-superblock" -s d -l dev -d 'Device to create superblock for' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand migrate-superblock" -s o -l offset -d 'Offset of existing superblock' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand migrate-superblock" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and not __fish_seen_subcommand_from status wait help" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and not __fish_seen_subcommand_from status wait help" -f -a "status" -d 'Show reconcile status'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and not __fish_seen_subcommand_from status wait help" -f -a "wait" -d 'Wait for reconcile to finish'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and not __fish_seen_subcommand_from status wait help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from status" -s t -l types -d 'Reconcile types to display (comma-separated)' -r -f -a "{replicas\t'',checksum\t'',erasure_code\t'',compression\t'',target\t'',high_priority\t'',pending\t'',stripes\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from status" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from wait" -s t -l types -d 'Reconcile types to wait on (comma-separated)' -r -f -a "{replicas\t'',checksum\t'',erasure_code\t'',compression\t'',target\t'',high_priority\t'',pending\t'',stripes\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from wait" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from help" -f -a "status" -d 'Show reconcile status'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from help" -f -a "wait" -d 'Wait for reconcile to finish'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand reconcile; and __fish_seen_subcommand_from help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s d -l dev_size -d 'Size of filesystem on device, in bytes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s o -l offset -d 'Offset to probe, in bytes (must be a multiple of 512)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s l -l scan_len -d 'Length in bytes to scan from start and end of device' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s s -l src_device -d 'Member device to recover from, in a multi-device fs' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s i -l dev_idx -d 'Index of this device, if recovering from another device' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s y -l yes -d 'Recover without prompting'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s v -l verbose -d 'Increase logging level'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recover-super" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recovery-pass" -s s -l set -d 'Schedule a recovery pass' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recovery-pass" -s u -l unset -d 'Deschedule a recovery pass' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand recovery-pass" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand scrub" -s m -l metadata -d 'Check metadata only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand scrub" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l block_size -l block-size -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l btree_node_size -l btree-node-size -d 'Btree node size, default 256k' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l errors -d 'Action to take on filesystem error' -r -f -a "{continue\t'',fix_safe\t'',panic\t'',ro\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l write_error_timeout -l write-error-timeout -d 'Number of consecutive write errors allowed before kicking out a device' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l metadata_replicas -l metadata-replicas -d 'Number of metadata replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l data_replicas -l data-replicas -d 'Number of data replicas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l encoded_extent_max -l encoded-extent-max -d 'Maximum size of checksummed/compressed extents' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l metadata_checksum -l metadata-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l data_checksum -l data-checksum -r -f -a "{none\t'',crc32c\t'',crc64\t'',xxhash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l checksum_err_retry_nr -l checksum-err-retry-nr -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l background_compression -l background-compression -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l str_hash -l str-hash -d 'Hash function for directory entries and xattrs' -r -f -a "{crc32c\t'',crc64\t'',siphash\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l metadata_target -l metadata-target -d 'Device or label for metadata writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l foreground_target -l foreground-target -d 'Device or label for foreground writes' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l background_target -l background-target -d 'Device or label to move data to in the background' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l promote_target -l promote-target -d 'Device or label to promote data to on read' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l erasure_code -l erasure-code -d 'Enable erasure coding (DO NOT USE YET)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l casefold -d 'Dirent lookups are casefolded' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l casefold_disabled -l casefold-disabled -d 'Disable casefolding filesystem wide' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l inodes_32bit -l inodes-32bit -d 'Constrain inode numbers to 32 bits' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l shard_inode_numbers_bits -l shard-inode-numbers-bits -d 'Shard new inode numbers by CPU id' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l btree_node_mem_ptr_optimization -l btree-node-mem-ptr-optimization -d 'Stash pointer to in memory btree node in btree ptr' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l gc_reserve_percent -l gc-reserve-percent -d 'Percentage of disk space to reserve for copygc' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l gc_reserve_bytes -l gc-reserve-bytes -d 'Amount of disk space to reserve for copygc Takes precedence over gc_reserve_percent if set' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l root_reserve_percent -l root-reserve-percent -d 'Percentage of disk space to reserve for superuser' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l wide_macs -l wide-macs -d 'Store full 128 bits of cryptographic MACs, instead of 80' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l inline_data -l inline-data -d 'Enable inline data extents' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l promote_whole_extents -l promote-whole-extents -d 'Promote whole extents, instead of just part being read' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l acl -d 'Enable POSIX acls' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l usrquota -d 'Enable user quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l grpquota -d 'Enable group quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l prjquota -d 'Enable project quotas' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l degraded -d 'Allow mounting in degraded mode' -r -f -a "{ask\t'',yes\t'',very\t'',no\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l no_splitbrain_check -l no-splitbrain-check -d 'Don\'t kick drives out when splitbrain detected' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l verbose -d 'Extra debugging information during mount/recovery' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l journal_flush_delay -l journal-flush-delay -d 'Delay in milliseconds before automatic journal commits' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l journal_flush_disabled -l journal-flush-disabled -d 'Disable journal flush on sync/fsync If enabled, writes can be lost, but only since the last journal write (default 1 second)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l journal_reclaim_delay -l journal-reclaim-delay -d 'Delay in milliseconds before automatic journal reclaim' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l writeback_timeout -l writeback-timeout -d 'Delay seconds before writing back dirty data, overriding vm sysctls' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l move_bytes_in_flight -l move-bytes-in-flight -d 'Maximum Amount of IO to keep in flight by the move path' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l move_ios_in_flight -l move-ios-in-flight -d 'Maximum number of IOs to keep in flight by the move path' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l fsck -d 'Run fsck on mount' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l fsck_memory_usage_percent -l fsck-memory-usage-percent -d 'Maximum percentage of system ram fsck is allowed to pin' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l fix_errors -l fix-errors -d 'Fix errors during fsck without asking' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l ratelimit_errors -l ratelimit-errors -d 'Ratelimit error messages during fsck' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l nochanges -d 'Super read only mode - no writes at all will be issued, even if we have to replay the journal' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l norecovery -d 'Exit recovery immediately prior to journal replay' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l journal_rewind -l journal-rewind -d 'Rewind journal' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l recovery_passes -l recovery-passes -d 'Recovery passes to run explicitly' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l recovery_passes_exclude -l recovery-passes-exclude -d 'Recovery passes to exclude' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l recovery_pass_last -l recovery-pass-last -d 'Exit recovery after specified pass' -r -f -a "{recovery_pass_empty\t'',scan_for_btree_nodes\t'',check_topology\t'',accounting_read\t'',alloc_read\t'',stripes_read\t'',initialize_subvolumes\t'',snapshots_read\t'',check_allocations\t'',trans_mark_dev_sbs\t'',fs_journal_alloc\t'',set_may_go_rw\t'',journal_replay\t'',merge_btree_nodes\t'',check_alloc_info\t'',check_lrus\t'',check_btree_backpointers\t'',check_backpointers_to_extents\t'',check_extents_to_backpointers\t'',check_alloc_to_lru_refs\t'',fs_freespace_init\t'',bucket_gens_init\t'',reconstruct_snapshots\t'',delete_dead_interior_snapshots\t'',check_snapshot_trees\t'',check_snapshots\t'',check_subvols\t'',check_subvol_children\t'',delete_dead_snapshots\t'',fs_upgrade_for_subvolumes\t'',check_inodes\t'',check_extents\t'',check_indirect_extents\t'',check_dirents\t'',check_xattrs\t'',check_root\t'',check_unreachable_inodes\t'',check_subvolume_structure\t'',check_directory_structure\t'',check_nlinks\t'',check_reconcile_work\t'',resume_logged_ops\t'',delete_dead_inodes\t'',kill_i_generation_keys\t'',fix_reflink_p\t'',set_fs_needs_reconcile\t'',btree_bitmap_gc\t'',lookup_root_inode\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l journal_transaction_names -l journal-transaction-names -d 'Log transaction function names in journal' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l allocator_stuck_timeout -l allocator-stuck-timeout -d 'Default timeout in seconds for stuck allocator messages' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l noexcl -d 'Don\'t open device in exclusive mode' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l direct_io -l direct-io -d 'Use O_DIRECT (userspace only)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l reconstruct_alloc -l reconstruct-alloc -d 'Reconstruct alloc btree' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l version_upgrade -l version-upgrade -d 'Set superblock to latest version, allowing any new features to be used' -r -f -a "{compatible\t'',incompatible\t'',none\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l nocow -d 'Nocow mode: Writes will be done in place when possible. Snapshots and reflink will still caused writes to be COW Implicitly disables data checksumming, compression and encryption' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l nocow_enabled -l nocow-enabled -d 'Enable nocow mode: enables runtime locking in data move path needed if nocow will ever be in use ' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l copygc_enabled -l copygc-enabled -d 'Enable copygc: disable for debugging, or to quiet the system when doing performance testing ' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l reconcile_enabled -l reconcile-enabled -d 'Enable reconcile: disable for debugging, or to quiet the system when doing performance testing ' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l reconcile_on_ac_only -l reconcile-on-ac-only -d 'Enable reconcile while on mains power only ' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l auto_snapshot_deletion -l auto-snapshot-deletion -d 'Enable automatic snapshot deletion: disable for debugging, or to quiet the system when doing performance testing ' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l state -d 'rw,ro,failed,spare' -r -f -a "{rw\t'',ro\t'',evacuating\t'',spare\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l bucket_size -l bucket-size -d 'Specifies the bucket size; must be greater than the btree node size' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l durability -d 'Data written to this device will be considered to have already been replicated n times' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l data_allowed -l data-allowed -d 'Allowed data types for this device: journal, btree, and/or user' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l discard -d 'Enable discard/TRIM support' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l rotational -d 'Disk is rotational; different behaviour for reconcile' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -l btree_node_prefetch -l btree-node-prefetch -d 'BTREE_ITER_prefetch causes btree nodes to be  prefetched sequentially' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -s d -l dev-idx -d 'Device index for device-specific options' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-fs-option" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand set-passphrase" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand remove-passphrase" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand show-super" -s f -l fields -d 'Superblock fields to print (comma-separated, or "all")' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand show-super" -s F -l field-only -d 'Print a single superblock field only (no header)' -r
complete -c bcachefs -n "__fish_bcachefs_using_subcommand show-super" -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand show-super" -s l -l layout -d 'Print superblock layout'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s k -l keyring -d 'Keyring to add to' -r -f -a "{session\t'',user\t'',user_session\t''}"
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s f -l file -d 'Passphrase file to read from (disables passphrase prompt)' -r -F
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s c -l check -d 'Check if a device is encrypted'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand unlock" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand strip-alloc" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand undump" -s f -l force -d 'Overwrite existing output files'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand undump" -s h -l help -d 'Print help'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "list" -d 'List filesystem metadata in textual form'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "mount" -d 'Mount a bcachefs filesystem by its UUID'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "completions" -d 'Generate shell completions'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "subvolume" -d 'Subvolumes-related commands'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "set-file-option" -d 'Set attributes on files in a bcachefs filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "reflink-option-propagate" -d 'Propagate IO options to reflinked extents'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "reset-counters" -d 'Reset filesystem counters'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "version" -d 'Display version'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "data" -d 'Manage filesystem data'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "device" -d 'Manage devices within a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "dump" -d 'Dump filesystem metadata to a qcow2 image'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "format" -d 'Format a new filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "fs" -d 'Manage a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "fsck" -d 'Check an existing filesystem for errors'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "image" -d 'Filesystem image commands'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "kill_btree_node" -d 'Kill a specific btree node (debugging)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "list_journal" -d 'List filesystem journal entries'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "migrate" -d 'Migrate an existing ext2/3/4 filesystem to bcachefs in place'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "migrate-superblock" -d 'Create default superblock after migrating'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "reconcile" -d 'Reconcile filesystem data'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "recover-super" -d 'Attempt to recover overwritten superblock from backups'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "recovery-pass" -d 'List and manage scheduled recovery passes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "set-fs-option" -d 'Set a filesystem option'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "set-passphrase" -d 'Change passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "remove-passphrase" -d 'Remove passphrase on an existing (unmounted) filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "show-super" -d 'Print superblock information to stdout'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "unlock" -d 'Unlock an encrypted filesystem prior to running/mounting'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "strip-alloc" -d 'Strip alloc info on a filesystem to be used read-only'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "undump" -d 'Convert qcow2 dump files back to raw device images'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and not __fish_seen_subcommand_from list mount completions subvolume set-file-option reflink-option-propagate reset-counters version data device dump format fs fsck image kill_btree_node list_journal migrate migrate-superblock reconcile recover-super recovery-pass scrub set-fs-option set-passphrase remove-passphrase show-super unlock strip-alloc undump help" -f -a "help" -d 'Print this message or the help of the given subcommand(s)'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "create" -d 'Create a new subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "delete" -d 'Delete an existing subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "snapshot" -d 'Create a snapshot of a subvolume'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "list" -d 'List subvolumes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from subvolume" -f -a "list-snapshots" -d 'List snapshots and their disk usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from data" -f -a "scrub" -d 'Verify checksums and correct errors, if possible'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "add" -d 'Add a new device to an existing filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "online" -d 'Re-add a device to a running filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "offline" -d 'Take a device offline, without removing it'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "remove" -d 'Remove a device from a filesystem'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "evacuate" -d 'Migrate data off a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "set-state" -d 'Change the state of a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "resize" -d 'Resize the filesystem on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from device" -f -a "resize-journal" -d 'Resize the journal on a device'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "usage" -d 'Display detailed filesystem usage'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "top" -d 'Display runtime performance info'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from fs" -f -a "timestats" -d 'Display bcachefs time statistics'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from image" -f -a "create" -d 'Create a filesystem image'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from image" -f -a "update" -d 'Update a filesystem image, minimizing changes'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from reconcile" -f -a "status" -d 'Show reconcile status'
complete -c bcachefs -n "__fish_bcachefs_using_subcommand help; and __fish_seen_subcommand_from reconcile" -f -a "wait" -d 'Wait for reconcile to finish'
