/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.commands;

import com.android.aapt.ConfigurationOuterClass;
import com.android.aapt.Resources;
import com.android.tools.build.bundletool.model.ResourceTableEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.model.exceptions.InvalidBundleException;
import com.android.tools.build.bundletool.model.exceptions.InvalidCommandException;
import com.android.tools.build.bundletool.model.utils.CollectorUtils;
import com.android.tools.build.bundletool.model.utils.ResourcesUtils;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoNode;
import com.android.tools.build.bundletool.model.utils.xmlproto.XmlProtoPrintUtils;
import com.android.tools.build.bundletool.xml.XPathResolver;
import com.android.tools.build.bundletool.xml.XmlNamespaceContext;
import com.android.tools.build.bundletool.xml.XmlProtoToXmlConverter;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.protobuf.util.JsonFormat;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;

public final class DumpManagerUtils {
    public static void printManifest(XmlProtoNode manifestProto, Optional<String> xPathExpression, PrintStream printStream) {
        String output;
        Document document = XmlProtoToXmlConverter.convert(manifestProto);
        if (xPathExpression.isPresent()) {
            try {
                XPath xPath = XPathFactory.newInstance().newXPath();
                xPath.setNamespaceContext(new XmlNamespaceContext(manifestProto));
                XPathExpression compiledXPathExpression = xPath.compile(xPathExpression.get());
                XPathResolver.XPathResult xPathResult = XPathResolver.resolve(document, compiledXPathExpression);
                output = xPathResult.toString();
            }
            catch (XPathExpressionException e11) {
                throw InvalidCommandException.builder().withInternalMessage("Error in the XPath expression: " + xPathExpression).withCause(e11).build();
            }
        } else {
            output = XmlUtils.documentToString(document);
        }
        printStream.println(output.trim());
    }

    public static void printBundleConfig(MessageOrBuilder bundleConfig, PrintStream printStream) {
        try {
            printStream.println(JsonFormat.printer().print(bundleConfig));
        }
        catch (IOException e11) {
            throw new UncheckedIOException("Error occurred when reading the bundle.", e11);
        }
    }

    public static void printResources(Predicate<ResourceTableEntry> resourcePredicate, boolean printValues, ImmutableList<Resources.ResourceTable> resourceTables, PrintStream printStream) {
        ImmutableListMultimap<String, ResourceTableEntry> entriesByPackageName = resourceTables.stream().flatMap(ResourcesUtils::entries).filter(resourcePredicate).collect(CollectorUtils.groupingBySortedKeys(entry -> entry.getPackage().getPackageName()));
        for (String packageName : entriesByPackageName.keySet()) {
            printStream.printf("Package '%s':%n", packageName);
            ((ImmutableList)entriesByPackageName.get((Object)packageName)).forEach(entry -> DumpManagerUtils.printEntry(entry, printValues, printStream));
            printStream.println();
        }
    }

    private static void printEntry(ResourceTableEntry entry, boolean printValues, PrintStream printStream) {
        printStream.printf("0x%08x - %s/%s%n", entry.getResourceId().getFullResourceId(), entry.getType().getName(), entry.getEntry().getName());
        for (Resources.ConfigValue configValue : entry.getEntry().getConfigValueList()) {
            printStream.print('\t');
            if (configValue.getConfig().equals(ConfigurationOuterClass.Configuration.getDefaultInstance())) {
                printStream.print("(default)");
            } else {
                printStream.print(TextFormat.printer().printToString(configValue.getConfig()).trim());
            }
            if (printValues) {
                printStream.printf(" - [%s] %s", XmlProtoPrintUtils.getValueTypeAsString(configValue.getValue()), XmlProtoPrintUtils.getValueAsString(configValue.getValue()));
            }
            printStream.println();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T extractAndParseFromSdkBundle(Path bundlePath, ZipPath filePath, ProtoParser<T> protoParser) {
        try (ZipFile zipFile = new ZipFile(bundlePath.toFile());){
            ZipEntry modulesFile = zipFile.getEntry("modules.resm");
            ZipInputStream zipInputStream = new ZipInputStream(zipFile.getInputStream(modulesFile));
            T t11 = DumpManagerUtils.extractAndParse(zipInputStream, filePath, protoParser);
            return t11;
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withUserMessage("Bundle is not a valid zip file.").withCause(e11).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("Error occurred when trying to open the bundle.", e12);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T extractAndParseFromAppBundle(Path bundlePath, ZipPath filePath, ProtoParser<T> protoParser) {
        try (ZipFile zipFile = new ZipFile(bundlePath.toFile());){
            T t11 = DumpManagerUtils.extractAndParse(zipFile, filePath, protoParser);
            return t11;
        }
        catch (ZipException e11) {
            throw InvalidBundleException.builder().withUserMessage("Bundle is not a valid zip file.").withCause(e11).build();
        }
        catch (IOException e12) {
            throw new UncheckedIOException("Error occurred when trying to open the bundle.", e12);
        }
    }

    public static <T> T extractAndParse(ZipInputStream zipInputStream, ZipPath filePath, ProtoParser<T> protoParser) {
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!zipEntry.getName().equals(filePath.toString())) continue;
                return protoParser.parse(zipInputStream);
            }
        }
        catch (IOException e11) {
            throw new UncheckedIOException("Error occurred when trying to read file '" + filePath + "' from bundle.", e11);
        }
        throw InvalidBundleException.builder().withUserMessage("File '%s' not found.", filePath).build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T extractAndParse(ZipFile zipFile, ZipPath filePath, ProtoParser<T> protoParser) {
        ZipEntry fileEntry = zipFile.getEntry(filePath.toString());
        if (fileEntry == null) {
            throw InvalidBundleException.builder().withUserMessage("File '%s' not found.", filePath).build();
        }
        try (InputStream inputStream = zipFile.getInputStream(fileEntry);){
            T t11 = protoParser.parse(inputStream);
            return t11;
        }
        catch (IOException e11) {
            throw new UncheckedIOException("Error occurred when trying to read file '" + filePath + "' from bundle.", e11);
        }
    }

    private DumpManagerUtils() {
    }

    public static interface ProtoParser<T> {
        public T parse(InputStream var1) throws IOException;
    }
}

