/*
 * Decompiled with CFR 0.152.
 */
package com.android.utils;

import com.google.common.base.CaseFormat;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SdkUtils {
    public static final String FILENAME_PREFIX = "From: ";
    public static final List<String> IMAGE_EXTENSIONS = ImmutableList.of(".png", ".9.png", ".gif", ".jpeg", ".jpg", ".bmp", ".webp", ".avif");

    public static boolean endsWithIgnoreCase(String string, String suffix) {
        return string.regionMatches(true, string.length() - suffix.length(), suffix, 0, suffix.length());
    }

    public static boolean endsWith(CharSequence sequence, CharSequence suffix) {
        return SdkUtils.endsWith(sequence, sequence.length(), suffix);
    }

    public static boolean endsWith(CharSequence sequence, int endOffset, CharSequence suffix) {
        if (endOffset < suffix.length()) {
            return false;
        }
        int i11 = endOffset - 1;
        for (int j11 = suffix.length() - 1; j11 >= 0; --j11) {
            if (sequence.charAt(i11) != suffix.charAt(j11)) {
                return false;
            }
            --i11;
        }
        return true;
    }

    public static boolean startsWithIgnoreCase(String string, String prefix) {
        return string.regionMatches(true, 0, prefix, 0, prefix.length());
    }

    public static String wrap(String text, int lineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, lineWidth, lineWidth, hangingIndent);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent) {
        return SdkUtils.wrap(text, firstLineWidth, nextLineWidth, hangingIndent, true);
    }

    public static String wrap(String text, int firstLineWidth, int nextLineWidth, String hangingIndent, boolean forceBreak) {
        if (hangingIndent == null) {
            hangingIndent = "";
        }
        int lineWidth = firstLineWidth;
        int explanationLength = text.length();
        StringBuilder sb2 = new StringBuilder(explanationLength * 2);
        int index = 0;
        while (index < explanationLength) {
            int next;
            int lineEnd = text.indexOf(10, index);
            if (lineEnd != -1 && lineEnd - index < lineWidth) {
                next = lineEnd + 1;
            } else {
                lineEnd = Math.min(index + lineWidth, explanationLength);
                if (lineEnd - index < lineWidth) {
                    next = explanationLength;
                } else {
                    int lastSpace = text.lastIndexOf(32, lineEnd);
                    if (lastSpace > index) {
                        lineEnd = lastSpace;
                        next = lastSpace + 1;
                    } else if (!forceBreak) {
                        char c11;
                        for (next = lineEnd; next < explanationLength && !Character.isWhitespace(c11 = text.charAt(next)); ++next) {
                            ++lineEnd;
                        }
                    }
                }
            }
            if (sb2.length() > 0) {
                sb2.append(hangingIndent);
            } else {
                lineWidth = nextLineWidth - hangingIndent.length();
            }
            sb2.append(text, index, lineEnd);
            sb2.append('\n');
            index = next;
        }
        return sb2.toString();
    }

    public static File urlToFile(String url) throws MalformedURLException {
        return SdkUtils.urlToFile(new URL(url));
    }

    public static File urlToFile(URL url) throws MalformedURLException {
        try {
            return new File(url.toURI());
        }
        catch (IllegalArgumentException e11) {
            MalformedURLException ex2 = new MalformedURLException(e11.getLocalizedMessage());
            ex2.initCause(e11);
            throw ex2;
        }
        catch (URISyntaxException e12) {
            return new File(url.getPath());
        }
    }

    public static FileLineColumnUrlData parseDecoratedFileUrlString(String string) {
        Matcher matcher = FileLineColumnUrlData.PATTERN.matcher(string);
        if (matcher.matches()) {
            Integer line = matcher.group(2) == null ? null : Integer.decode(matcher.group(2));
            Integer column = matcher.group(3) == null ? null : Integer.decode(matcher.group(3));
            return new FileLineColumnUrlData(string.substring(0, matcher.start(1)), line, column);
        }
        return new FileLineColumnUrlData(string, null, null);
    }

    public static String fileToUrlString(File file2) throws MalformedURLException {
        String url = SdkUtils.fileToUrl(file2).toExternalForm();
        if (!url.startsWith("file:///")) {
            url = url.replaceFirst("file:/", "file:///");
        }
        return url;
    }

    public static URL fileToUrl(File file2) throws MalformedURLException {
        return file2.toURI().toURL();
    }

    public static String createPathComment(File file2, boolean includePadding) throws MalformedURLException {
        String url = SdkUtils.fileToUrlString(file2);
        int dashes = url.indexOf("--");
        if (dashes != -1) {
            url = url.replace("--", "%2D%2D");
        }
        if (includePadding) {
            return " From: " + url + " ";
        }
        return FILENAME_PREFIX + url;
    }

    public static String xmlNameToConstantName(String xmlName) {
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.UPPER_UNDERSCORE, xmlName);
    }

    public static String camelCaseToConstantName(String camelCaseName) {
        return CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_UNDERSCORE, camelCaseName);
    }

    public static String constantNameToCamelCase(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, constantName);
    }

    public static String constantNameToXmlName(String constantName) {
        return CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, constantName);
    }

    public static String fileNameToResourceName(String fileName) {
        int lastExtension = fileName.lastIndexOf(46);
        if (lastExtension <= 0) {
            return fileName;
        }
        if (fileName.endsWith(".9.png")) {
            if (fileName.length() > ".9.png".length()) {
                return fileName.substring(0, fileName.length() - ".9.png".length());
            }
            return fileName;
        }
        return fileName.substring(0, lastExtension);
    }

    public static String getLayoutName(File layoutFile) {
        String name = layoutFile.getName();
        int dotIndex = name.indexOf(46);
        if (dotIndex != -1) {
            name = name.substring(0, dotIndex);
        }
        return name;
    }

    public static boolean hasImageExtension(String path) {
        for (String ext : IMAGE_EXTENSIONS) {
            if (!SdkUtils.endsWithIgnoreCase(path, ext)) continue;
            return true;
        }
        return false;
    }

    public static boolean isBitmapFile(File file2) {
        return SdkUtils.hasImageExtension(file2.getPath());
    }

    public static String escapePropertyValue(String value) {
        Properties properties = new Properties();
        properties.setProperty("k", value);
        StringWriter writer = new StringWriter();
        try {
            properties.store(writer, null);
            String s11 = writer.toString();
            int end = s11.length();
            String lineSeparator = System.lineSeparator();
            if (s11.endsWith(lineSeparator)) {
                end -= lineSeparator.length();
            }
            int start = s11.indexOf(61);
            assert (start != -1) : s11;
            return s11.substring(start + 1, end);
        }
        catch (IOException e11) {
            return value;
        }
    }

    public static String globToRegexp(String glob) {
        StringBuilder sb2 = new StringBuilder(glob.length() * 2);
        int begin = 0;
        sb2.append('^');
        int n11 = glob.length();
        for (int i11 = 0; i11 < n11; ++i11) {
            char c11 = glob.charAt(i11);
            if (c11 == '*') {
                begin = SdkUtils.appendQuoted(sb2, glob, begin, i11) + 1;
                if (i11 < n11 - 1 && glob.charAt(i11 + 1) == '*') {
                    ++i11;
                    ++begin;
                }
                sb2.append(".*?");
                continue;
            }
            if (c11 != '?') continue;
            begin = SdkUtils.appendQuoted(sb2, glob, begin, i11) + 1;
            sb2.append(".?");
        }
        SdkUtils.appendQuoted(sb2, glob, begin, glob.length());
        sb2.append('$');
        return sb2.toString();
    }

    private static int appendQuoted(StringBuilder sb2, String s11, int from, int to2) {
        if (to2 > from) {
            int i11;
            boolean isSimple = true;
            for (i11 = from; i11 < to2; ++i11) {
                char c11 = s11.charAt(i11);
                if (Character.isLetterOrDigit(c11) || c11 == '/' || c11 == ' ') continue;
                isSimple = false;
                break;
            }
            if (isSimple) {
                for (i11 = from; i11 < to2; ++i11) {
                    sb2.append(s11.charAt(i11));
                }
                return to2;
            }
            sb2.append(Pattern.quote(s11.substring(from, to2)));
        }
        return to2;
    }

    public static boolean isServiceKey(String name) {
        switch (name) {
            case "gcm_defaultSenderId": 
            case "google_app_id": 
            case "google_api_key": 
            case "google_storage_bucket": 
            case "ga_trackingID": 
            case "default_web_client_id": 
            case "firebase_database_url": 
            case "google_crash_reporting_api_key": {
                return true;
            }
        }
        return false;
    }

    public static class FileLineColumnUrlData {
        public static final Pattern PATTERN = Pattern.compile(".*?(:(\\d+)(?::(\\d+))?)$");
        public final String urlString;
        public final Integer line;
        public final Integer column;

        FileLineColumnUrlData(String urlString, Integer line, Integer column) {
            this.urlString = urlString;
            this.line = line;
            this.column = column;
        }
    }
}

