/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.FunctionParameterContext;
import com.sun.jna.FunctionResultContext;
import com.sun.jna.Memory;
import com.sun.jna.MethodParameterContext;
import com.sun.jna.MethodResultContext;
import com.sun.jna.Native;
import com.sun.jna.NativeLibrary;
import com.sun.jna.NativeMapped;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.StringArray;
import com.sun.jna.Structure;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.VarArgsChecker;
import com.sun.jna.WString;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;

public class Function
extends Pointer {
    public static final int MAX_NARGS = 256;
    public static final int C_CONVENTION = 0;
    public static final int ALT_CONVENTION = 63;
    private static final int MASK_CC = 63;
    public static final int THROW_LAST_ERROR = 64;
    public static final int USE_VARARGS = 384;
    static final Integer INTEGER_TRUE = -1;
    static final Integer INTEGER_FALSE = 0;
    private NativeLibrary library;
    private final String functionName;
    final String encoding;
    final int callFlags;
    final Map<String, ?> options;
    static final String OPTION_INVOKING_METHOD = "invoking-method";
    private static final VarArgsChecker IS_VARARGS = VarArgsChecker.create();

    public static Function getFunction(String libraryName, String functionName) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName);
    }

    public static Function getFunction(String libraryName, String functionName, int callFlags) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callFlags, null);
    }

    public static Function getFunction(String libraryName, String functionName, int callFlags, String encoding) {
        return NativeLibrary.getInstance(libraryName).getFunction(functionName, callFlags, encoding);
    }

    public static Function getFunction(Pointer p11) {
        return Function.getFunction(p11, 0, null);
    }

    public static Function getFunction(Pointer p11, int callFlags) {
        return Function.getFunction(p11, callFlags, null);
    }

    public static Function getFunction(Pointer p11, int callFlags, String encoding) {
        return new Function(p11, callFlags, encoding);
    }

    Function(NativeLibrary library, String functionName, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionName == null) {
            throw new NullPointerException("Function name must not be null");
        }
        this.library = library;
        this.functionName = functionName;
        this.callFlags = callFlags;
        this.options = library.options;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
        try {
            this.peer = library.getSymbolAddress(functionName);
        }
        catch (UnsatisfiedLinkError e11) {
            throw new UnsatisfiedLinkError("Error looking up function '" + functionName + "': " + e11.getMessage());
        }
    }

    Function(Pointer functionAddress, int callFlags, String encoding) {
        this.checkCallingConvention(callFlags & 0x3F);
        if (functionAddress == null || functionAddress.peer == 0L) {
            throw new NullPointerException("Function address may not be null");
        }
        this.functionName = functionAddress.toString();
        this.callFlags = callFlags;
        this.peer = functionAddress.peer;
        this.options = Collections.EMPTY_MAP;
        this.encoding = encoding != null ? encoding : Native.getDefaultStringEncoding();
    }

    private void checkCallingConvention(int convention) throws IllegalArgumentException {
        if ((convention & 0x3F) != convention) {
            throw new IllegalArgumentException("Unrecognized calling convention: " + convention);
        }
    }

    public String getName() {
        return this.functionName;
    }

    public int getCallingConvention() {
        return this.callFlags & 0x3F;
    }

    public Object invoke(Class<?> returnType, Object[] inArgs) {
        return this.invoke(returnType, inArgs, this.options);
    }

    public Object invoke(Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        Method invokingMethod = (Method)options.get(OPTION_INVOKING_METHOD);
        Class<?>[] paramTypes = invokingMethod != null ? invokingMethod.getParameterTypes() : null;
        return this.invoke(invokingMethod, paramTypes, returnType, inArgs, options);
    }

    Object invoke(Method invokingMethod, Class<?>[] paramTypes, Class<?> returnType, Object[] inArgs, Map<String, ?> options) {
        Object[] args2 = new Object[]{};
        if (inArgs != null) {
            if (inArgs.length > 256) {
                throw new UnsupportedOperationException("Maximum argument count is 256");
            }
            args2 = new Object[inArgs.length];
            System.arraycopy(inArgs, 0, args2, 0, args2.length);
        }
        TypeMapper mapper = (TypeMapper)options.get("type-mapper");
        boolean allowObjects = Boolean.TRUE.equals(options.get("allow-objects"));
        boolean isVarArgs = args2.length > 0 && invokingMethod != null ? Function.isVarArgs(invokingMethod) : false;
        int fixedArgs = args2.length > 0 && invokingMethod != null ? Function.fixedArgs(invokingMethod) : 0;
        for (int i11 = 0; i11 < args2.length; ++i11) {
            Class<?> paramType = invokingMethod != null ? (isVarArgs && i11 >= paramTypes.length - 1 ? paramTypes[paramTypes.length - 1].getComponentType() : paramTypes[i11]) : null;
            args2[i11] = this.convertArgument(args2, i11, invokingMethod, mapper, allowObjects, paramType);
        }
        Class<?> nativeReturnType = returnType;
        FromNativeConverter resultConverter = null;
        if (NativeMapped.class.isAssignableFrom(returnType)) {
            NativeMappedConverter tc2 = NativeMappedConverter.getInstance(returnType);
            resultConverter = tc2;
            nativeReturnType = tc2.nativeType();
        } else if (mapper != null && (resultConverter = mapper.getFromNativeConverter(returnType)) != null) {
            nativeReturnType = resultConverter.nativeType();
        }
        Object result = this.invoke(args2, nativeReturnType, allowObjects, fixedArgs);
        if (resultConverter != null) {
            FunctionResultContext context = invokingMethod != null ? new MethodResultContext(returnType, this, inArgs, invokingMethod) : new FunctionResultContext(returnType, this, inArgs);
            result = resultConverter.fromNative(result, context);
        }
        if (inArgs != null) {
            for (int i12 = 0; i12 < inArgs.length; ++i12) {
                Object inArg = inArgs[i12];
                if (inArg == null) continue;
                if (inArg instanceof Structure) {
                    if (inArg instanceof Structure.ByValue) continue;
                    ((Structure)inArg).autoRead();
                    continue;
                }
                if (args2[i12] instanceof PostCallRead) {
                    ((PostCallRead)args2[i12]).read();
                    if (!(args2[i12] instanceof PointerArray)) continue;
                    PointerArray array = (PointerArray)args2[i12];
                    if (!Structure.ByReference[].class.isAssignableFrom(inArg.getClass())) continue;
                    Class<?> type = inArg.getClass().getComponentType();
                    Structure[] ss2 = (Structure[])inArg;
                    for (int si2 = 0; si2 < ss2.length; ++si2) {
                        Pointer p11 = array.getPointer(Native.POINTER_SIZE * si2);
                        ss2[si2] = Structure.updateStructureByReference(type, ss2[si2], p11);
                    }
                    continue;
                }
                if (!Structure[].class.isAssignableFrom(inArg.getClass())) continue;
                Structure.autoRead((Structure[])inArg);
            }
        }
        return result;
    }

    Object invoke(Object[] args2, Class<?> returnType, boolean allowObjects) {
        return this.invoke(args2, returnType, allowObjects, 0);
    }

    Object invoke(Object[] args2, Class<?> returnType, boolean allowObjects, int fixedArgs) {
        Object result = null;
        int callFlags = this.callFlags | (fixedArgs & 3) << 7;
        if (returnType == null || returnType == Void.TYPE || returnType == Void.class) {
            Native.invokeVoid(this, this.peer, callFlags, args2);
            result = null;
        } else if (returnType == Boolean.TYPE || returnType == Boolean.class) {
            result = Function.valueOf(Native.invokeInt(this, this.peer, callFlags, args2) != 0);
        } else if (returnType == Byte.TYPE || returnType == Byte.class) {
            result = (byte)Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType == Short.TYPE || returnType == Short.class) {
            result = (short)Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType == Character.TYPE || returnType == Character.class) {
            result = Character.valueOf((char)Native.invokeInt(this, this.peer, callFlags, args2));
        } else if (returnType == Integer.TYPE || returnType == Integer.class) {
            result = Native.invokeInt(this, this.peer, callFlags, args2);
        } else if (returnType == Long.TYPE || returnType == Long.class) {
            result = Native.invokeLong(this, this.peer, callFlags, args2);
        } else if (returnType == Float.TYPE || returnType == Float.class) {
            result = Float.valueOf(Native.invokeFloat(this, this.peer, callFlags, args2));
        } else if (returnType == Double.TYPE || returnType == Double.class) {
            result = Native.invokeDouble(this, this.peer, callFlags, args2);
        } else if (returnType == String.class) {
            result = this.invokeString(callFlags, args2, false);
        } else if (returnType == WString.class) {
            String s11 = this.invokeString(callFlags, args2, true);
            if (s11 != null) {
                result = new WString(s11);
            }
        } else {
            if (Pointer.class.isAssignableFrom(returnType)) {
                return this.invokePointer(callFlags, args2);
            }
            if (Structure.class.isAssignableFrom(returnType)) {
                if (Structure.ByValue.class.isAssignableFrom(returnType)) {
                    Structure s12 = Native.invokeStructure(this, this.peer, callFlags, args2, Structure.newInstance(returnType));
                    s12.autoRead();
                    result = s12;
                } else {
                    result = this.invokePointer(callFlags, args2);
                    if (result != null) {
                        Object s13 = Structure.newInstance(returnType, (Pointer)result);
                        ((Structure)s13).conditionalAutoRead();
                        result = s13;
                    }
                }
            } else if (Callback.class.isAssignableFrom(returnType)) {
                result = this.invokePointer(callFlags, args2);
                if (result != null) {
                    result = CallbackReference.getCallback(returnType, (Pointer)result);
                }
            } else if (returnType == String[].class) {
                Pointer p11 = this.invokePointer(callFlags, args2);
                if (p11 != null) {
                    result = p11.getStringArray(0L, this.encoding);
                }
            } else if (returnType == WString[].class) {
                Pointer p12 = this.invokePointer(callFlags, args2);
                if (p12 != null) {
                    String[] arr = p12.getWideStringArray(0L);
                    WString[] warr = new WString[arr.length];
                    for (int i11 = 0; i11 < arr.length; ++i11) {
                        warr[i11] = new WString(arr[i11]);
                    }
                    result = warr;
                }
            } else if (returnType == Pointer[].class) {
                Pointer p13 = this.invokePointer(callFlags, args2);
                if (p13 != null) {
                    result = p13.getPointerArray(0L);
                }
            } else if (allowObjects) {
                result = Native.invokeObject(this, this.peer, callFlags, args2);
                if (result != null && !returnType.isAssignableFrom(result.getClass())) {
                    throw new ClassCastException("Return type " + returnType + " does not match result " + result.getClass());
                }
            } else {
                throw new IllegalArgumentException("Unsupported return type " + returnType + " in function " + this.getName());
            }
        }
        return result;
    }

    private Pointer invokePointer(int callFlags, Object[] args2) {
        long ptr = Native.invokePointer(this, this.peer, callFlags, args2);
        return ptr == 0L ? null : new Pointer(ptr);
    }

    private Object convertArgument(Object[] args2, int index, Method invokingMethod, TypeMapper mapper, boolean allowObjects, Class<?> expectedType) {
        Object arg = args2[index];
        if (arg != null) {
            Class<?> type = arg.getClass();
            ToNativeConverter converter = null;
            if (NativeMapped.class.isAssignableFrom(type)) {
                converter = NativeMappedConverter.getInstance(type);
            } else if (mapper != null) {
                converter = mapper.getToNativeConverter(type);
            }
            if (converter != null) {
                FunctionParameterContext context = invokingMethod != null ? new MethodParameterContext(this, args2, index, invokingMethod) : new FunctionParameterContext(this, args2, index);
                arg = converter.toNative(arg, context);
            }
        }
        if (arg == null || this.isPrimitiveArray(arg.getClass())) {
            return arg;
        }
        Class<?> argClass = arg.getClass();
        if (arg instanceof Structure) {
            Structure struct = (Structure)arg;
            struct.autoWrite();
            if (struct instanceof Structure.ByValue) {
                Class<?> ptype = struct.getClass();
                if (invokingMethod != null) {
                    Class<?>[] ptypes = invokingMethod.getParameterTypes();
                    if (IS_VARARGS.isVarArgs(invokingMethod)) {
                        if (index < ptypes.length - 1) {
                            ptype = ptypes[index];
                        } else {
                            Class<?> etype = ptypes[ptypes.length - 1].getComponentType();
                            if (etype != Object.class) {
                                ptype = etype;
                            }
                        }
                    } else {
                        ptype = ptypes[index];
                    }
                }
                if (Structure.ByValue.class.isAssignableFrom(ptype)) {
                    return struct;
                }
            }
            return struct.getPointer();
        }
        if (arg instanceof Callback) {
            return CallbackReference.getFunctionPointer((Callback)arg);
        }
        if (arg instanceof String) {
            return new NativeString((String)arg, false).getPointer();
        }
        if (arg instanceof WString) {
            return new NativeString(arg.toString(), true).getPointer();
        }
        if (arg instanceof Boolean) {
            return Boolean.TRUE.equals(arg) ? INTEGER_TRUE : INTEGER_FALSE;
        }
        if (String[].class == argClass) {
            return new StringArray((String[])arg, this.encoding);
        }
        if (WString[].class == argClass) {
            return new StringArray((WString[])arg);
        }
        if (Pointer[].class == argClass) {
            return new PointerArray((Pointer[])arg);
        }
        if (NativeMapped[].class.isAssignableFrom(argClass)) {
            return new NativeMappedArray((NativeMapped[])arg);
        }
        if (Structure[].class.isAssignableFrom(argClass)) {
            Structure[] ss2 = (Structure[])arg;
            Class<?> type = argClass.getComponentType();
            boolean byRef = Structure.ByReference.class.isAssignableFrom(type);
            if (expectedType != null && !Structure.ByReference[].class.isAssignableFrom(expectedType)) {
                if (byRef) {
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index + " but array of " + type + " was passed");
                }
                for (int i11 = 0; i11 < ss2.length; ++i11) {
                    if (!(ss2[i11] instanceof Structure.ByReference)) continue;
                    throw new IllegalArgumentException("Function " + this.getName() + " declared Structure[] at parameter " + index + " but element " + i11 + " is of Structure.ByReference type");
                }
            }
            if (byRef) {
                Structure.autoWrite(ss2);
                Pointer[] pointers = new Pointer[ss2.length + 1];
                for (int i12 = 0; i12 < ss2.length; ++i12) {
                    pointers[i12] = ss2[i12] != null ? ss2[i12].getPointer() : null;
                }
                return new PointerArray(pointers);
            }
            if (ss2.length == 0) {
                throw new IllegalArgumentException("Structure array must have non-zero length");
            }
            if (ss2[0] == null) {
                ((Structure)Structure.newInstance(type)).toArray(ss2);
                return ss2[0].getPointer();
            }
            Structure.autoWrite(ss2);
            return ss2[0].getPointer();
        }
        if (argClass.isArray()) {
            throw new IllegalArgumentException("Unsupported array argument type: " + argClass.getComponentType());
        }
        if (allowObjects) {
            return arg;
        }
        if (!Native.isSupportedNativeType(arg.getClass())) {
            throw new IllegalArgumentException("Unsupported argument type " + arg.getClass().getName() + " at parameter " + index + " of function " + this.getName());
        }
        return arg;
    }

    private boolean isPrimitiveArray(Class<?> argClass) {
        return argClass.isArray() && argClass.getComponentType().isPrimitive();
    }

    public void invoke(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    private String invokeString(int callFlags, Object[] args2, boolean wide) {
        Pointer ptr = this.invokePointer(callFlags, args2);
        String s11 = null;
        if (ptr != null) {
            s11 = wide ? ptr.getWideString(0L) : ptr.getString(0L, this.encoding);
        }
        return s11;
    }

    @Override
    public String toString() {
        if (this.library != null) {
            return "native function " + this.functionName + "(" + this.library.getName() + ")@0x" + Long.toHexString(this.peer);
        }
        return "native function@0x" + Long.toHexString(this.peer);
    }

    public Object invokeObject(Object[] args2) {
        return this.invoke(Object.class, args2);
    }

    public Pointer invokePointer(Object[] args2) {
        return (Pointer)this.invoke(Pointer.class, args2);
    }

    public String invokeString(Object[] args2, boolean wide) {
        Object o11 = this.invoke(wide ? WString.class : String.class, args2);
        return o11 != null ? o11.toString() : null;
    }

    public int invokeInt(Object[] args2) {
        return (Integer)this.invoke(Integer.class, args2);
    }

    public long invokeLong(Object[] args2) {
        return (Long)this.invoke(Long.class, args2);
    }

    public float invokeFloat(Object[] args2) {
        return ((Float)this.invoke(Float.class, args2)).floatValue();
    }

    public double invokeDouble(Object[] args2) {
        return (Double)this.invoke(Double.class, args2);
    }

    public void invokeVoid(Object[] args2) {
        this.invoke(Void.class, args2);
    }

    @Override
    public boolean equals(Object o11) {
        if (o11 == this) {
            return true;
        }
        if (o11 == null) {
            return false;
        }
        if (o11.getClass() == this.getClass()) {
            Function other = (Function)o11;
            return other.callFlags == this.callFlags && other.options.equals(this.options) && other.peer == this.peer;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.callFlags + this.options.hashCode() + super.hashCode();
    }

    static Object[] concatenateVarArgs(Object[] inArgs) {
        if (inArgs != null && inArgs.length > 0) {
            Class<?> argType;
            Object lastArg = inArgs[inArgs.length - 1];
            Class<?> clazz = argType = lastArg != null ? lastArg.getClass() : null;
            if (argType != null && argType.isArray()) {
                Object[] varArgs = (Object[])lastArg;
                for (int i11 = 0; i11 < varArgs.length; ++i11) {
                    if (!(varArgs[i11] instanceof Float)) continue;
                    varArgs[i11] = (double)((Float)varArgs[i11]).floatValue();
                }
                Object[] fullArgs = new Object[inArgs.length + varArgs.length];
                System.arraycopy(inArgs, 0, fullArgs, 0, inArgs.length - 1);
                System.arraycopy(varArgs, 0, fullArgs, inArgs.length - 1, varArgs.length);
                fullArgs[fullArgs.length - 1] = null;
                inArgs = fullArgs;
            }
        }
        return inArgs;
    }

    static boolean isVarArgs(Method m11) {
        return IS_VARARGS.isVarArgs(m11);
    }

    static int fixedArgs(Method m11) {
        return IS_VARARGS.fixedArgs(m11);
    }

    static Boolean valueOf(boolean b11) {
        return b11 ? Boolean.TRUE : Boolean.FALSE;
    }

    private static class PointerArray
    extends Memory
    implements PostCallRead {
        private final Pointer[] original;

        public PointerArray(Pointer[] arg) {
            super(Native.POINTER_SIZE * (arg.length + 1));
            this.original = arg;
            for (int i11 = 0; i11 < arg.length; ++i11) {
                this.setPointer(i11 * Native.POINTER_SIZE, arg[i11]);
            }
            this.setPointer(Native.POINTER_SIZE * arg.length, null);
        }

        @Override
        public void read() {
            this.read(0L, this.original, 0, this.original.length);
        }
    }

    private static class NativeMappedArray
    extends Memory
    implements PostCallRead {
        private final NativeMapped[] original;

        public NativeMappedArray(NativeMapped[] arg) {
            super(Native.getNativeSize(arg.getClass(), arg));
            this.original = arg;
            this.setValue(0L, this.original, this.original.getClass());
        }

        @Override
        public void read() {
            this.getValue(0L, this.original.getClass(), this.original);
        }
    }

    public static interface PostCallRead {
        public void read();
    }
}

