/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    public StringArray(String[] strings) {
        this(strings, false);
    }

    public StringArray(String[] strings, boolean wide) {
        this((Object[])strings, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] strings, String encoding) {
        this((Object[])strings, encoding);
    }

    public StringArray(WString[] strings) {
        this(strings, "--WIDE-STRING--");
    }

    private StringArray(Object[] strings, String encoding) {
        super((strings.length + 1) * Native.POINTER_SIZE);
        this.original = strings;
        this.encoding = encoding;
        for (int i11 = 0; i11 < strings.length; ++i11) {
            Pointer p11 = null;
            if (strings[i11] != null) {
                NativeString ns2 = new NativeString(strings[i11].toString(), encoding);
                this.natives.add(ns2);
                p11 = ns2.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i11, p11);
        }
        this.setPointer(Native.POINTER_SIZE * strings.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        for (int si2 = 0; si2 < this.original.length; ++si2) {
            Pointer p11 = this.getPointer(si2 * Native.POINTER_SIZE);
            CharSequence s11 = null;
            if (p11 != null) {
                String string = s11 = wide ? p11.getWideString(0L) : p11.getString(0L, this.encoding);
                if (returnWide) {
                    s11 = new WString((String)s11);
                }
            }
            this.original[si2] = s11;
        }
    }

    @Override
    public String toString() {
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        String s11 = wide ? "const wchar_t*[]" : "const char*[]";
        s11 = s11 + Arrays.asList(this.original);
        return s11;
    }
}

