/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import org.cryptomator.cryptolib.common.ObjectPool;

public final class MacSupplier {
    public static final MacSupplier HMAC_SHA256 = new MacSupplier("HmacSHA256");
    private final String macAlgorithm;
    private final ObjectPool<Mac> macPool;

    public MacSupplier(String macAlgorithm) {
        this.macAlgorithm = macAlgorithm;
        this.macPool = new ObjectPool<Mac>(this::createMac);
        try (ObjectPool.Lease<Mac> lease = this.macPool.get();){
            lease.get();
        }
    }

    private Mac createMac() {
        try {
            return Mac.getInstance(this.macAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid MAC algorithm.", e);
        }
    }

    public ObjectPool.Lease<Mac> keyed(SecretKey key) {
        ObjectPool.Lease<Mac> lease = this.macPool.get();
        this.init(lease.get(), key);
        return lease;
    }

    @Deprecated
    public Mac withKey(SecretKey key) {
        Mac mac = this.createMac();
        this.init(mac, key);
        return mac;
    }

    private void init(Mac mac, SecretKey key) {
        try {
            mac.init(key);
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key.", e);
        }
    }
}

