/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.Arrays;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.api.MasterkeyLoadingFailedException;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.MasterkeyFile;
import org.cryptomator.cryptolib.common.Scrypt;

public class MasterkeyFileAccess {
    private static final int DEFAULT_MASTERKEY_FILE_VERSION = 999;
    private static final int DEFAULT_SCRYPT_SALT_LENGTH = 8;
    private static final int DEFAULT_SCRYPT_COST_PARAM = 32768;
    private static final int DEFAULT_SCRYPT_BLOCK_SIZE = 8;
    private final byte[] pepper;
    private final SecureRandom csprng;

    public MasterkeyFileAccess(byte[] pepper, SecureRandom csprng) {
        this.pepper = pepper;
        this.csprng = csprng;
    }

    @Deprecated
    public static int readAllegedVaultVersion(byte[] masterkey) throws IOException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(masterkey);){
            int n;
            try (InputStreamReader reader = new InputStreamReader((InputStream)in, StandardCharsets.UTF_8);){
                MasterkeyFile parsedFile = MasterkeyFile.read(reader);
                n = parsedFile.version;
            }
            return n;
        }
    }

    public byte[] changePassphrase(byte[] masterkey, CharSequence oldPassphrase, CharSequence newPassphrase) throws IOException, InvalidPassphraseException {
        try (ByteArrayInputStream in = new ByteArrayInputStream(masterkey);){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                this.changePassphrase(in, out, oldPassphrase, newPassphrase);
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public void changePassphrase(InputStream oldIn, OutputStream newOut, CharSequence oldPassphrase, CharSequence newPassphrase) throws IOException, InvalidPassphraseException {
        try (InputStreamReader reader = new InputStreamReader(oldIn, StandardCharsets.UTF_8);
             OutputStreamWriter writer = new OutputStreamWriter(newOut, StandardCharsets.UTF_8);){
            MasterkeyFile original = MasterkeyFile.read(reader);
            MasterkeyFile updated = this.changePassphrase(original, oldPassphrase, newPassphrase);
            updated.write(writer);
        }
    }

    MasterkeyFile changePassphrase(MasterkeyFile masterkey, CharSequence oldPassphrase, CharSequence newPassphrase) throws InvalidPassphraseException {
        try (Masterkey key = this.unlock(masterkey, oldPassphrase);){
            MasterkeyFile masterkeyFile = this.lock(key, newPassphrase, masterkey.version, masterkey.scryptCostParam);
            return masterkeyFile;
        }
    }

    public Masterkey load(Path filePath, CharSequence passphrase) throws MasterkeyLoadingFailedException {
        Masterkey masterkey;
        block8: {
            InputStream in = Files.newInputStream(filePath, StandardOpenOption.READ);
            try {
                masterkey = this.load(in, passphrase);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new MasterkeyLoadingFailedException("I/O error", e);
                }
            }
            in.close();
        }
        return masterkey;
    }

    public Masterkey load(InputStream in, CharSequence passphrase) throws IOException {
        try (InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);){
            MasterkeyFile parsedFile = MasterkeyFile.read(reader);
            if (!parsedFile.isValid()) {
                throw new IOException("Invalid key file");
            }
            Masterkey masterkey = this.unlock(parsedFile, passphrase);
            return masterkey;
        }
    }

    /*
     * Exception decompiling
     */
    Masterkey unlock(MasterkeyFile parsedFile, CharSequence passphrase) throws InvalidPassphraseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void persist(Masterkey masterkey, Path filePath, CharSequence passphrase) throws IOException {
        this.persist(masterkey, filePath, passphrase, 999);
    }

    public void persist(Masterkey masterkey, Path filePath, CharSequence passphrase, @Deprecated int vaultVersion) throws IOException {
        Path tmpFilePath = filePath.resolveSibling(filePath.getFileName().toString() + ".tmp");
        try (OutputStream out = Files.newOutputStream(tmpFilePath, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            this.persist(masterkey, out, passphrase, vaultVersion);
        }
        Files.move(tmpFilePath, filePath, StandardCopyOption.REPLACE_EXISTING);
    }

    public void persist(Masterkey masterkey, OutputStream out, CharSequence passphrase, @Deprecated int vaultVersion) throws IOException {
        this.persist(masterkey, out, passphrase, vaultVersion, 32768);
    }

    void persist(Masterkey masterkey, OutputStream out, CharSequence passphrase, @Deprecated int vaultVersion, int scryptCostParam) throws IOException {
        Preconditions.checkArgument((!masterkey.isDestroyed() ? 1 : 0) != 0, (Object)"masterkey has been destroyed");
        MasterkeyFile fileContent = this.lock(masterkey, passphrase, vaultVersion, scryptCostParam);
        try (OutputStreamWriter writer = new OutputStreamWriter(out, StandardCharsets.UTF_8);){
            fileContent.write(writer);
        }
    }

    /*
     * Exception decompiling
     */
    MasterkeyFile lock(Masterkey masterkey, CharSequence passphrase, int vaultVersion, int scryptCostParam) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DestroyableSecretKey scrypt(CharSequence passphrase, byte[] salt, byte[] pepper, int costParam, int blockSize) {
        byte[] saltAndPepper = new byte[salt.length + pepper.length];
        System.arraycopy(salt, 0, saltAndPepper, 0, salt.length);
        System.arraycopy(pepper, 0, saltAndPepper, salt.length, pepper.length);
        byte[] kekBytes = Scrypt.scrypt(passphrase, saltAndPepper, costParam, blockSize, 32);
        try {
            DestroyableSecretKey destroyableSecretKey = new DestroyableSecretKey(kekBytes, "AES");
            return destroyableSecretKey;
        }
        finally {
            Arrays.fill(kekBytes, (byte)0);
        }
    }
}

