/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.cryptomator.cryptolib.common.ObjectPool;

public final class MessageDigestSupplier {
    public static final MessageDigestSupplier SHA1 = new MessageDigestSupplier("SHA-1");
    public static final MessageDigestSupplier SHA256 = new MessageDigestSupplier("SHA-256");
    private final String digestAlgorithm;
    private final ObjectPool<MessageDigest> mdPool;

    public MessageDigestSupplier(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
        this.mdPool = new ObjectPool<MessageDigest>(this::createMessageDigest);
        try (ObjectPool.Lease<MessageDigest> lease = this.mdPool.get();){
            lease.get();
        }
    }

    private MessageDigest createMessageDigest() {
        try {
            return MessageDigest.getInstance(this.digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("Invalid digest algorithm.", e);
        }
    }

    public ObjectPool.Lease<MessageDigest> instance() {
        ObjectPool.Lease<MessageDigest> lease = this.mdPool.get();
        lease.get().reset();
        return lease;
    }

    @Deprecated
    public MessageDigest get() {
        MessageDigest result = this.createMessageDigest();
        result.reset();
        return result;
    }
}

