/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.cryptomator.cryptolib.common.ECKeyPair;
import org.cryptomator.cryptolib.common.Pkcs12Exception;
import org.cryptomator.cryptolib.common.Pkcs12Helper;
import org.cryptomator.cryptolib.common.Pkcs12PasswordException;

public class P384KeyPair
extends ECKeyPair {
    private static final String EC_ALG = "EC";
    private static final String EC_CURVE_NAME = "secp384r1";
    private static final String SIGNATURE_ALG = "SHA384withECDSA";

    private P384KeyPair(KeyPair keyPair) {
        super(keyPair, P384KeyPair.getCurveParams());
    }

    public static P384KeyPair generate() {
        KeyPair keyPair = P384KeyPair.getKeyPairGenerator().generateKeyPair();
        return new P384KeyPair(keyPair);
    }

    public static P384KeyPair create(X509EncodedKeySpec publicKeySpec, PKCS8EncodedKeySpec privateKeySpec) throws InvalidKeySpecException {
        try {
            KeyFactory factory = KeyFactory.getInstance(EC_ALG);
            PublicKey publicKey = factory.generatePublic(publicKeySpec);
            PrivateKey privateKey = factory.generatePrivate(privateKeySpec);
            return new P384KeyPair(new KeyPair(publicKey, privateKey));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("EC not supported");
        }
    }

    public static P384KeyPair load(Path p12File, char[] passphrase) throws IOException, Pkcs12PasswordException, Pkcs12Exception {
        try (InputStream in = Files.newInputStream(p12File, StandardOpenOption.READ);){
            P384KeyPair p384KeyPair = P384KeyPair.load(in, passphrase);
            return p384KeyPair;
        }
    }

    public static P384KeyPair load(InputStream in, char[] passphrase) throws IOException, Pkcs12PasswordException, Pkcs12Exception {
        KeyPair keyPair = Pkcs12Helper.importFrom(in, passphrase);
        return new P384KeyPair(keyPair);
    }

    public void store(Path p12File, char[] passphrase) throws IOException, Pkcs12Exception {
        Path tmpFile = p12File.resolveSibling(p12File.getFileName().toString() + ".tmp");
        try (OutputStream out = Files.newOutputStream(tmpFile, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);){
            this.store(out, passphrase);
        }
        Files.move(tmpFile, p12File, StandardCopyOption.REPLACE_EXISTING);
    }

    public void store(OutputStream out, char[] passphrase) throws IOException, Pkcs12Exception {
        Pkcs12Helper.exportTo(this.keyPair(), out, passphrase, SIGNATURE_ALG);
    }

    private static KeyPairGenerator getKeyPairGenerator() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance(EC_ALG);
            keyGen.initialize(new ECGenParameterSpec(EC_CURVE_NAME));
            return keyGen;
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("secp384r1 curve not supported");
        }
    }

    private static ECParameterSpec getCurveParams() {
        try {
            AlgorithmParameters parameters = AlgorithmParameters.getInstance(EC_ALG);
            parameters.init(new ECGenParameterSpec(EC_CURVE_NAME));
            return parameters.getParameterSpec(ECParameterSpec.class);
        }
        catch (NoSuchAlgorithmException | InvalidParameterSpecException e) {
            throw new IllegalStateException("secp384r1 curve not supported");
        }
    }
}

