/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.provider.ntru;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import org.cryptomator.cryptolib.shaded.bouncycastle.asn1.ASN1Set;
import org.cryptomator.cryptolib.shaded.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.util.PrivateKeyFactory;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.crypto.util.PrivateKeyInfoFactory;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.interfaces.NTRUKey;
import org.cryptomator.cryptolib.shaded.bouncycastle.pqc.jcajce.spec.NTRUParameterSpec;
import org.cryptomator.cryptolib.shaded.bouncycastle.util.Arrays;

public class BCNTRUPrivateKey
implements PrivateKey,
NTRUKey {
    private static final long serialVersionUID = 1L;
    private transient NTRUPrivateKeyParameters params;
    private transient ASN1Set attributes;

    public BCNTRUPrivateKey(NTRUPrivateKeyParameters nTRUPrivateKeyParameters) {
        this.params = nTRUPrivateKeyParameters;
    }

    public BCNTRUPrivateKey(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.init(privateKeyInfo);
    }

    private void init(PrivateKeyInfo privateKeyInfo) throws IOException {
        this.attributes = privateKeyInfo.getAttributes();
        this.params = (NTRUPrivateKeyParameters)PrivateKeyFactory.createKey(privateKeyInfo);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof BCNTRUPrivateKey) {
            BCNTRUPrivateKey bCNTRUPrivateKey = (BCNTRUPrivateKey)object;
            return Arrays.areEqual(this.params.getEncoded(), bCNTRUPrivateKey.params.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.params.getEncoded());
    }

    @Override
    public final String getAlgorithm() {
        return "NTRU";
    }

    @Override
    public byte[] getEncoded() {
        try {
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfoFactory.createPrivateKeyInfo(this.params, this.attributes);
            return privateKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public NTRUParameterSpec getParameterSpec() {
        return NTRUParameterSpec.fromName(this.params.getParameters().getName());
    }

    @Override
    public String getFormat() {
        return "PKCS#8";
    }

    NTRUPrivateKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte[] byArray = (byte[])objectInputStream.readObject();
        this.init(PrivateKeyInfo.getInstance(byArray));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.getEncoded());
    }
}

