/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import dagger.Module;
import dagger.Provides;
import jakarta.inject.Named;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.Optional;
import org.cryptomator.cryptofs.CryptoFileSystemProperties;
import org.cryptomator.cryptofs.attr.AttributeScoped;
import org.cryptomator.cryptofs.attr.CryptoBasicFileAttributes;
import org.cryptomator.cryptofs.attr.CryptoDosFileAttributes;
import org.cryptomator.cryptofs.attr.CryptoPosixFileAttributes;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.fh.OpenCryptoFile;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;
import org.cryptomator.cryptolib.api.Cryptor;

@Module
abstract class AttributeModule {
    AttributeModule() {
    }

    @Provides
    @AttributeScoped
    public static Optional<OpenCryptoFile> provideOpenCryptoFile(OpenCryptoFiles openCryptoFiles, Path ciphertextPath) {
        return openCryptoFiles.get(ciphertextPath);
    }

    @Provides
    @Named(value="cleartext")
    @AttributeScoped
    public static BasicFileAttributes provideAttributes(@Named(value="ciphertext") BasicFileAttributes ciphertextAttributes, CiphertextFileType ciphertextFileType, Path ciphertextPath, Cryptor cryptor, Optional<OpenCryptoFile> openCryptoFile, CryptoFileSystemProperties fileSystemProperties) {
        if (ciphertextAttributes instanceof PosixFileAttributes) {
            PosixFileAttributes attr = (PosixFileAttributes)ciphertextAttributes;
            return new CryptoPosixFileAttributes(attr, ciphertextFileType, ciphertextPath, cryptor, openCryptoFile, fileSystemProperties);
        }
        if (ciphertextAttributes instanceof DosFileAttributes) {
            DosFileAttributes attr = (DosFileAttributes)ciphertextAttributes;
            return new CryptoDosFileAttributes(attr, ciphertextFileType, ciphertextPath, cryptor, openCryptoFile, fileSystemProperties);
        }
        return new CryptoBasicFileAttributes(ciphertextAttributes, ciphertextFileType, ciphertextPath, cryptor, openCryptoFile);
    }
}

