/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.attr;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.ReadonlyFlag;
import org.cryptomator.cryptofs.Symlinks;
import org.cryptomator.cryptofs.attr.AbstractCryptoFileAttributeView;
import org.cryptomator.cryptofs.attr.AttributeViewScoped;
import org.cryptomator.cryptofs.fh.OpenCryptoFiles;

@AttributeViewScoped
final class CryptoFileOwnerAttributeView
extends AbstractCryptoFileAttributeView
implements FileOwnerAttributeView {
    private final ReadonlyFlag readonlyFlag;

    @Inject
    public CryptoFileOwnerAttributeView(CryptoPath cleartextPath, CryptoPathMapper pathMapper, LinkOption[] linkOptions, Symlinks symlinks, OpenCryptoFiles openCryptoFiles, ReadonlyFlag readonlyFlag) {
        super(cleartextPath, pathMapper, linkOptions, symlinks, openCryptoFiles);
        this.readonlyFlag = readonlyFlag;
    }

    @Override
    public String name() {
        return "owner";
    }

    @Override
    public UserPrincipal getOwner() throws IOException {
        return this.getCiphertextAttributeView(FileOwnerAttributeView.class).getOwner();
    }

    @Override
    public void setOwner(UserPrincipal owner) throws IOException {
        this.readonlyFlag.assertWritable();
        this.getCiphertextAttributeView(FileOwnerAttributeView.class).setOwner(owner);
    }
}

