/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.dir;

import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.ClosedFileSystemException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.cryptomator.cryptofs.CiphertextDirectory;
import org.cryptomator.cryptofs.CryptoFileSystemScoped;
import org.cryptomator.cryptofs.CryptoPath;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.dir.CryptoDirectoryStream;
import org.cryptomator.cryptofs.dir.DirectoryStreamComponent;

@CryptoFileSystemScoped
public class DirectoryStreamFactory {
    private final CryptoPathMapper cryptoPathMapper;
    private final DirectoryStreamComponent.Factory directoryStreamComponentFactory;
    private final Map<CryptoDirectoryStream, DirectoryStream<Path>> streams = new HashMap<CryptoDirectoryStream, DirectoryStream<Path>>();
    private volatile boolean closed = false;

    @Inject
    public DirectoryStreamFactory(CryptoPathMapper cryptoPathMapper, DirectoryStreamComponent.Factory directoryStreamComponentFactory) {
        this.cryptoPathMapper = cryptoPathMapper;
        this.directoryStreamComponentFactory = directoryStreamComponentFactory;
    }

    public synchronized CryptoDirectoryStream newDirectoryStream(CryptoPath cleartextDir, DirectoryStream.Filter<? super Path> filter) throws IOException {
        if (this.closed) {
            throw new ClosedFileSystemException();
        }
        CiphertextDirectory ciphertextDir = this.cryptoPathMapper.getCiphertextDir(cleartextDir);
        DirectoryStream<Path> ciphertextDirStream = Files.newDirectoryStream(ciphertextDir.path(), this::matchesEncryptedContentPattern);
        CryptoDirectoryStream cleartextDirStream = this.directoryStreamComponentFactory.create(cleartextDir, ciphertextDir.dirId(), ciphertextDirStream, filter, this.streams::remove).directoryStream();
        this.streams.put(cleartextDirStream, ciphertextDirStream);
        return cleartextDirStream;
    }

    boolean matchesEncryptedContentPattern(Path path) {
        String tmp = path.getFileName().toString();
        return tmp.length() >= 28 && (tmp.endsWith(".c9r") || tmp.endsWith(".c9s"));
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        IOException exception = new IOException("Close failed");
        Iterator<Map.Entry<CryptoDirectoryStream, DirectoryStream<Path>>> iter = this.streams.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<CryptoDirectoryStream, DirectoryStream<Path>> entry = iter.next();
            iter.remove();
            try {
                entry.getKey().close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                exception.addSuppressed(e);
            }
        }
        if (exception.getSuppressed().length > 0) {
            throw exception;
        }
    }
}

