/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.migration.v8;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.UUID;
import org.cryptomator.cryptofs.common.BackupHelper;
import org.cryptomator.cryptofs.migration.api.MigrationContinuationListener;
import org.cryptomator.cryptofs.migration.api.MigrationProgressListener;
import org.cryptomator.cryptofs.migration.api.Migrator;
import org.cryptomator.cryptolib.api.CryptoException;
import org.cryptomator.cryptolib.api.Masterkey;
import org.cryptomator.cryptolib.common.MasterkeyFileAccess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Version8Migrator
implements Migrator {
    private static final Logger LOG = LoggerFactory.getLogger(Version8Migrator.class);
    private final SecureRandom csprng;

    @Inject
    public Version8Migrator(SecureRandom csprng) {
        this.csprng = csprng;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void migrate(Path vaultRoot, String vaultConfigFilename, String masterkeyFilename, CharSequence passphrase, MigrationProgressListener progressListener, MigrationContinuationListener continuationListener) throws CryptoException, IOException {
        LOG.info("Upgrading {} from version 7 to version 8.", (Object)vaultRoot);
        progressListener.update(MigrationProgressListener.ProgressState.INITIALIZING, 0.0);
        Path masterkeyFile = vaultRoot.resolve(masterkeyFilename);
        Path vaultConfigFile = vaultRoot.resolve(vaultConfigFilename);
        byte[] rawKey = new byte[]{};
        MasterkeyFileAccess masterkeyFileAccess = new MasterkeyFileAccess(new byte[0], this.csprng);
        try (Masterkey masterkey = masterkeyFileAccess.load(masterkeyFile, passphrase);){
            Path masterkeyBackupFile = BackupHelper.attemptBackup(masterkeyFile);
            LOG.info("Backed up masterkey from {} to {}.", (Object)masterkeyFile.getFileName(), (Object)masterkeyBackupFile.getFileName());
            rawKey = masterkey.getEncoded();
            Algorithm algorithm = Algorithm.HMAC256((byte[])rawKey);
            String config = JWT.create().withJWTId(UUID.randomUUID().toString()).withKeyId("masterkeyfile:masterkey.cryptomator").withClaim("format", Integer.valueOf(8)).withClaim("cipherCombo", "SIV_CTRMAC").withClaim("shorteningThreshold", Integer.valueOf(220)).sign(algorithm);
            Files.writeString(vaultConfigFile, (CharSequence)config, StandardCharsets.US_ASCII, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
            LOG.info("Wrote vault config to {}.", (Object)vaultConfigFile);
            progressListener.update(MigrationProgressListener.ProgressState.FINALIZING, 0.0);
            masterkeyFileAccess.persist(masterkey, masterkeyFile, passphrase, 999);
            LOG.info("Updated masterkey.");
        }
        finally {
            Arrays.fill(rawKey, (byte)0);
        }
        LOG.info("Upgraded {} from version 7 to version 8.", (Object)vaultRoot);
    }
}

