/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.linux.keychain;

import de.swiesend.secretservice.simple.SimpleCollection;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.cryptomator.integrations.common.DisplayName;
import org.cryptomator.integrations.common.OperatingSystem;
import org.cryptomator.integrations.common.Priority;
import org.cryptomator.integrations.keychain.KeychainAccessException;
import org.cryptomator.integrations.keychain.KeychainAccessProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=900)
@OperatingSystem(value=OperatingSystem.Value.LINUX)
@DisplayName(value="GNOME Keyring")
public class GnomeKeyringKeychainAccess
implements KeychainAccessProvider {
    private static final Logger LOG = LoggerFactory.getLogger(GnomeKeyringKeychainAccess.class);
    private final String LABEL_FOR_SECRET_IN_KEYRING = "Cryptomator";

    public boolean isSupported() {
        try {
            return SimpleCollection.isGnomeKeyringAvailable();
        }
        catch (RuntimeException e) {
            LOG.warn("Initializing secret service keychain access failed", (Throwable)e);
            return false;
        }
        catch (ExceptionInInitializerError err) {
            LOG.warn("Initializing secret service keychain access failed", err.getException());
            return false;
        }
    }

    public boolean isLocked() {
        boolean bl;
        SimpleCollection keyring = new SimpleCollection();
        try {
            bl = keyring.isLocked();
        }
        catch (Throwable throwable) {
            try {
                try {
                    keyring.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return true;
            }
        }
        keyring.close();
        return bl;
    }

    public void storePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list == null || list.isEmpty()) {
                keyring.createItem("Cryptomator", passphrase, this.createAttributes(key));
            } else {
                this.changePassphrase(key, displayName, passphrase);
            }
        }
        catch (IOException | SecurityException e) {
            throw new KeychainAccessException("Storing password failed.", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public char[] loadPassphrase(String key) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                char[] cArray = keyring.getSecret((String)list.get(0));
                return cArray;
            }
            char[] cArray = null;
            return cArray;
        }
        catch (IOException | SecurityException e) {
            throw new KeychainAccessException("Loading password failed.", (Throwable)e);
        }
    }

    public void deletePassphrase(String key) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                keyring.deleteItem((String)list.get(0));
            }
        }
        catch (IOException | SecurityException e) {
            throw new KeychainAccessException("Deleting password failed.", (Throwable)e);
        }
    }

    public void changePassphrase(String key, String displayName, CharSequence passphrase) throws KeychainAccessException {
        try (SimpleCollection keyring = new SimpleCollection();){
            List list = keyring.getItems(this.createAttributes(key));
            if (list != null && !list.isEmpty()) {
                keyring.updateItem((String)list.get(0), "Cryptomator", passphrase, this.createAttributes(key));
            }
        }
        catch (IOException | SecurityException e) {
            throw new KeychainAccessException("Changing password failed.", (Throwable)e);
        }
    }

    private Map<String, String> createAttributes(String key) {
        return Map.of("Vault", key);
    }
}

