/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.api;

import java.nio.file.attribute.PosixFilePermission;
import java.util.EnumSet;
import java.util.Set;

public final class FileModes {
    public static final int PERMISSIONS_MASK = 511;

    private FileModes() {
    }

    public static Set<PosixFilePermission> toPermissions(int mode) {
        EnumSet<PosixFilePermission> permissions = EnumSet.noneOf(PosixFilePermission.class);
        if ((mode & 0x100) == 256) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if ((mode & 0x80) == 128) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x40) == 64) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x20) == 32) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x10) == 16) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 8) == 8) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 4) == 4) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 2) == 2) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 1) == 1) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        return permissions;
    }

    public static int fromPermissions(Set<PosixFilePermission> permissions) {
        int mode = 0;
        if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
            mode |= 0x100;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
            mode |= 0x80;
        }
        if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
            mode |= 0x40;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
            mode |= 0x20;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
            mode |= 0x10;
        }
        if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
            mode |= 8;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
            mode |= 4;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
            mode |= 2;
        }
        if (permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) {
            mode |= 1;
        }
        return mode;
    }
}

