/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client;

import io.github.coffeelibs.tinyoauth2client.util.RandomUtil;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;

class PKCE {
    public static final String METHOD = "S256";
    private final String challenge;
    private final String verifier = RandomUtil.randomToken(43);

    public PKCE() {
        this.challenge = Base64.getUrlEncoder().withoutPadding().encodeToString(PKCE.sha256(this.verifier.getBytes(StandardCharsets.US_ASCII)));
    }

    public String getChallenge() {
        return this.challenge;
    }

    public String getVerifier() {
        return this.verifier;
    }

    private static byte[] sha256(byte[] input) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            return digest.digest(input);
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

