/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client.http;

import io.github.coffeelibs.tinyoauth2client.http.InvalidRequestException;
import io.github.coffeelibs.tinyoauth2client.http.response.Response;
import io.github.coffeelibs.tinyoauth2client.util.RandomUtil;
import io.github.coffeelibs.tinyoauth2client.util.URIUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.AlreadyBoundException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.Blocking;
import org.jetbrains.annotations.VisibleForTesting;

public class RedirectTarget
implements Closeable {
    static final InetAddress LOOPBACK_ADDR = InetAddress.getLoopbackAddress();
    private final ServerSocketChannel serverChannel;
    private final String path;
    private final String csrfToken;
    private Response successResponse = Response.empty(Response.Status.OK);
    private Response errorResponse = Response.empty(Response.Status.OK);

    private RedirectTarget(ServerSocketChannel serverChannel, String path) {
        this.serverChannel = serverChannel;
        this.path = path;
        this.csrfToken = RandomUtil.randomToken(16);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RedirectTarget start(String path, int ... ports) throws IOException {
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("Path needs to be absolute");
        }
        ServerSocketChannel ch = null;
        boolean success = false;
        try {
            ch = ServerSocketChannel.open();
            RedirectTarget.tryBind(ch, ports);
            ch.configureBlocking(true);
            success = true;
            RedirectTarget redirectTarget = new RedirectTarget(ch, path);
            return redirectTarget;
        }
        finally {
            if (!success && ch != null) {
                ch.close();
            }
        }
    }

    @VisibleForTesting
    static void tryBind(ServerSocketChannel ch, int ... ports) throws IOException {
        if (ports.length != 0) {
            for (int port : ports) {
                try {
                    ch.bind(new InetSocketAddress(LOOPBACK_ADDR, port));
                    return;
                }
                catch (AlreadyBoundException alreadyBoundException) {
                }
            }
            throw new AlreadyBoundException();
        }
        ch.bind(new InetSocketAddress(LOOPBACK_ADDR, 0));
    }

    public void setSuccessResponse(Response successResponse) {
        this.successResponse = Objects.requireNonNull(successResponse);
    }

    public void setErrorResponse(Response errorResponse) {
        this.errorResponse = Objects.requireNonNull(errorResponse);
    }

    public URI getRedirectUri() {
        try {
            return new URI("http", null, LOOPBACK_ADDR.getHostAddress(), this.serverChannel.socket().getLocalPort(), this.path, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getCsrfToken() {
        return this.csrfToken;
    }

    @Blocking
    public String receive() throws IOException {
        SocketChannel client = this.serverChannel.accept();
        try (BufferedReader reader = new BufferedReader(Channels.newReader((ReadableByteChannel)client, StandardCharsets.US_ASCII));
             Writer writer = Channels.newWriter((WritableByteChannel)client, StandardCharsets.UTF_8);){
            URI requestUri;
            String requestLine = reader.readLine();
            try {
                requestUri = RedirectTarget.parseRequestLine(requestLine);
            }
            catch (InvalidRequestException e) {
                e.suggestedResponse.write(writer);
                throw new IOException("Unparseable Request", e);
            }
            if (!Path.of(this.path, new String[0]).equals(Path.of(requestUri.getPath(), new String[0]))) {
                Response.empty(Response.Status.NOT_FOUND).write(writer);
                throw new IOException("Requested invalid path " + String.valueOf(requestUri));
            }
            Map<String, String> params = URIUtil.parseQueryString(requestUri.getRawQuery());
            if (!this.csrfToken.equals(params.get("state"))) {
                Response.empty(Response.Status.BAD_REQUEST).write(writer);
                throw new IOException("Missing or invalid state token");
            }
            if (params.containsKey("error")) {
                this.errorResponse.write(writer);
                throw new IOException("Authorization failed");
            }
            if (params.containsKey("code")) {
                this.successResponse.write(writer);
                String string = params.get("code");
                return string;
            }
            Response.empty(Response.Status.BAD_REQUEST).write(writer);
            throw new IOException("Missing authorization code");
        }
    }

    @VisibleForTesting
    static URI parseRequestLine(String requestLine) throws InvalidRequestException {
        String[] words = requestLine.split(" ");
        if (words.length < 3) {
            throw new InvalidRequestException(Response.empty(Response.Status.BAD_REQUEST));
        }
        String method = words[0];
        if (!"GET".equals(method)) {
            throw new InvalidRequestException(Response.empty(Response.Status.METHOD_NOT_ALLOWED));
        }
        try {
            return new URI(words[1]);
        }
        catch (URISyntaxException e) {
            throw new InvalidRequestException(Response.empty(Response.Status.BAD_REQUEST));
        }
    }

    @Override
    public void close() throws IOException {
        this.serverChannel.close();
    }
}

