/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client.util;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Base64;

public class RandomUtil {
    private static final SecureRandom CSPRNG;

    private RandomUtil() {
    }

    public static String randomToken(int len) {
        int numBytes = (len + 3) / 4 * 3;
        byte[] bytes = RandomUtil.randomBytes(numBytes);
        String str = Base64.getUrlEncoder().withoutPadding().encodeToString(bytes);
        return str.substring(0, len);
    }

    private static byte[] randomBytes(int len) {
        byte[] bytes = new byte[len];
        CSPRNG.nextBytes(bytes);
        return bytes;
    }

    static {
        try {
            CSPRNG = SecureRandom.getInstanceStrong();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }
}

