/*
 * Decompiled with CFR 0.152.
 */
package io.github.coffeelibs.tinyoauth2client.util;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public class URIUtil {
    private URIUtil() {
    }

    public static Map<String, String> parseQueryString(@Nullable String rawQuery) {
        if (rawQuery == null) {
            return Map.of();
        }
        return Pattern.compile("&").splitAsStream(rawQuery).filter(Predicate.not(String::isEmpty)).map(element -> {
            int sep = element.indexOf("=");
            if (sep == -1) {
                String key = URLDecoder.decode(element, StandardCharsets.UTF_8);
                return Map.entry(key, "");
            }
            String key = URLDecoder.decode(element.substring(0, sep), StandardCharsets.UTF_8);
            String val = URLDecoder.decode(element.substring(sep + 1), StandardCharsets.UTF_8);
            return Map.entry(key, val);
        }).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static String buildQueryString(Map<String, String> queryParams) {
        return queryParams.entrySet().stream().map(entry -> {
            String encodedKey = URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8);
            String encodedValue = URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8);
            return encodedKey + (String)(encodedValue.isBlank() ? "" : "=" + encodedValue);
        }).collect(Collectors.joining("&"));
    }
}

