/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.linux.amd64;

import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.platforms.Architecture;
import org.cryptomator.jfuse.api.platforms.OperatingSystem;
import org.cryptomator.jfuse.api.platforms.SupportedPlatform;
import org.cryptomator.jfuse.linux.amd64.FuseImpl;
import org.cryptomator.jfuse.linux.amd64.LinuxErrno;

@SupportedPlatform(os=OperatingSystem.LINUX, arch=Architecture.AMD64)
public class LinuxFuseBuilder
implements FuseBuilder {
    private static final String DEFAULT_LIBNAME = "fuse3";
    private static final Errno ERRNO = new LinuxErrno();
    private String libraryPath;

    public Errno errno() {
        return ERRNO;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public Fuse build(FuseOperations fuseOperations) throws UnsatisfiedLinkError {
        if (this.libraryPath != null) {
            System.load(this.libraryPath);
        } else {
            System.loadLibrary(DEFAULT_LIBNAME);
        }
        return new FuseImpl(fuseOperations);
    }
}

