/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.jfuse.mac;

import org.cryptomator.jfuse.api.Errno;
import org.cryptomator.jfuse.api.Fuse;
import org.cryptomator.jfuse.api.FuseBuilder;
import org.cryptomator.jfuse.api.FuseOperations;
import org.cryptomator.jfuse.api.platforms.Architecture;
import org.cryptomator.jfuse.api.platforms.OperatingSystem;
import org.cryptomator.jfuse.api.platforms.SupportedPlatform;
import org.cryptomator.jfuse.api.platforms.SupportedPlatforms;
import org.cryptomator.jfuse.mac.FuseImpl;
import org.cryptomator.jfuse.mac.MacErrno;

@SupportedPlatforms(value={@SupportedPlatform(os=OperatingSystem.MAC, arch=Architecture.AMD64), @SupportedPlatform(os=OperatingSystem.MAC, arch=Architecture.ARM64)})
public class MacFuseBuilder
implements FuseBuilder {
    private static final String DEFAULT_MACFUSE_LIBNAME = "fuse";
    private static final String DEFAULT_FUSET_LIBNAMNE = "fuse-t";
    private static final Errno ERRNO = new MacErrno();
    private String libraryPath;

    public Errno errno() {
        return ERRNO;
    }

    public void setLibraryPath(String libraryPath) {
        this.libraryPath = libraryPath;
    }

    public Fuse build(FuseOperations fuseOperations) throws UnsatisfiedLinkError {
        if (this.libraryPath != null) {
            System.load(this.libraryPath);
        } else {
            try {
                System.loadLibrary(DEFAULT_MACFUSE_LIBNAME);
            }
            catch (UnsatisfiedLinkError errorLoadingMacFuse) {
                try {
                    System.loadLibrary(DEFAULT_FUSET_LIBNAMNE);
                }
                catch (UnsatisfiedLinkError errorLoadingFuseT) {
                    errorLoadingFuseT.addSuppressed(errorLoadingMacFuse);
                    throw errorLoadingFuseT;
                }
            }
        }
        return new FuseImpl(fuseOperations);
    }
}

