/*
 * Decompiled with CFR 0.152.
 */
package org.purejava.kwallet;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapEntries {
    private final Logger log = LoggerFactory.getLogger(MapEntries.class);
    private Map<String, String> map = new HashMap<String, String>();
    private final byte[] EMPTY_ENTRY = new byte[]{-1, -1, -1, -1};
    private final byte[] EMPTY_VALUE = new byte[]{0, 0, 0, 0};

    public void storeEntry(String key, String value) {
        this.map.put(Objects.toString(key, ""), Objects.toString(value, ""));
    }

    public void removeEntry(String key, String value) {
        this.map.remove(key, value);
    }

    public boolean hasKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean hasValue(String key, String value) {
        return this.hasKey(key) && this.map.get(key).equals(value);
    }

    public String getValue(String key) {
        return this.hasKey(key) && null != this.map.get(key) ? this.map.get(key) : "";
    }

    public boolean changeValue(String key, String value) {
        if (this.hasKey(key)) {
            this.storeEntry(key, value);
            return true;
        }
        return false;
    }

    public int count() {
        return null != this.map && !this.map.isEmpty() ? this.map.size() : 0;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] getByteField() {
        if (null == this.map || this.map.isEmpty()) {
            return new byte[0];
        }
        try (ByteArrayOutputStream b = new ByteArrayOutputStream();){
            Object object;
            try (DataOutputStream s = new DataOutputStream(b);){
                s.writeInt(this.map.size());
                for (Map.Entry<String, String> entry : this.map.entrySet()) {
                    if (null == entry.getKey() || entry.getKey().isEmpty()) {
                        s.write(this.EMPTY_ENTRY);
                        s.write(this.EMPTY_ENTRY);
                        continue;
                    }
                    if (null == entry.getValue() || entry.getValue().isEmpty()) {
                        s.writeInt(entry.getKey().length() * 2);
                        s.writeChars(entry.getKey());
                        s.write(this.EMPTY_VALUE);
                        continue;
                    }
                    s.writeInt(entry.getKey().length() * 2);
                    s.writeChars(entry.getKey());
                    s.writeInt(entry.getValue().length() * 2);
                    s.writeChars(entry.getValue());
                }
                object = b.toByteArray();
            }
            return object;
        }
        catch (IOException e) {
            this.log.error(e.toString(), e.getCause());
            return new byte[0];
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean setByteField(byte[] s) {
        this.map = new HashMap<String, String>();
        if (null == s || s.length == 0) {
            return true;
        }
        try (ByteArrayInputStream b = new ByteArrayInputStream(s);){
            boolean bl;
            try (DataInputStream x = new DataInputStream(b);){
                int mapSize = x.readInt() & 0xFF;
                for (int i = 0; i < mapSize; ++i) {
                    byte[] nextPart = new byte[4];
                    for (int k = 0; k < nextPart.length; ++k) {
                        nextPart[k] = x.readByte();
                    }
                    if (Arrays.equals(nextPart, this.EMPTY_ENTRY)) {
                        this.map.put("", "");
                        x.skipBytes(4);
                        continue;
                    }
                    int keySize = this.fourBytesToInt(nextPart) / 2;
                    StringBuilder k = new StringBuilder();
                    for (int j = 0; j < keySize; ++j) {
                        k.append(x.readChar());
                    }
                    nextPart = new byte[4];
                    for (int l = 0; l < nextPart.length; ++l) {
                        nextPart[l] = x.readByte();
                    }
                    if (Arrays.equals(nextPart, this.EMPTY_VALUE)) {
                        this.map.put(k.toString(), "");
                        continue;
                    }
                    int valueSize = this.fourBytesToInt(nextPart) / 2;
                    StringBuilder v = new StringBuilder();
                    for (int j = 0; j < valueSize; ++j) {
                        v.append(x.readChar());
                    }
                    this.map.put(k.toString(), v.toString());
                }
                bl = true;
            }
            return bl;
        }
        catch (IOException e) {
            this.log.error(e.toString(), e.getCause());
            return false;
        }
    }

    private int fourBytesToInt(byte[] b) {
        return (b[0] << 24) + (b[1] << 16) + (b[2] << 8) + (b[3] << 0) & 0xFF;
    }

    public String toString() {
        StringBuilder sout = new StringBuilder();
        int i = 1;
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String value;
            String key = entry.getKey();
            if (key.isEmpty()) {
                key = "''";
            }
            if ((value = entry.getValue()).isEmpty()) {
                value = "''";
            }
            sout.append("MapEntries (").append(i).append(") {key: ").append(key).append(", value: ").append(value).append("}\n");
            ++i;
        }
        return sout.substring(0, sout.toString().length() - 1);
    }
}

