/*
 * Decompiled with CFR 0.152.
 */
package org.purejava.kwallet.freedesktop.dbus.handlers;

import java.util.List;
import org.freedesktop.dbus.ObjectPath;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.types.Variant;
import org.purejava.kwallet.Static;
import org.purejava.kwallet.freedesktop.dbus.handlers.MessageHandler;
import org.purejava.kwallet.freedesktop.dbus.handlers.SignalHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Messaging {
    private static final Logger LOG = LoggerFactory.getLogger(Messaging.class);
    private DBusConnection connection;
    private MessageHandler msg;
    private SignalHandler sh = SignalHandler.getInstance();
    private String serviceName;
    private String objectPath;
    private String interfaceName;

    public Messaging(DBusConnection connection, List<Class<? extends DBusSignal>> signals, String serviceName, String objectPath, String interfaceName) {
        this.connection = connection;
        this.msg = new MessageHandler(connection);
        if (null != signals) {
            this.sh.connect(connection, signals);
        }
        if (null == serviceName || null == objectPath) {
            LOG.error("Severe error: Kwallet daemon not initialized properly");
        }
        this.serviceName = serviceName;
        this.objectPath = objectPath;
        this.interfaceName = interfaceName;
    }

    public Object[] send(String method) {
        return this.msg.send(this.serviceName, this.objectPath, this.interfaceName, method, "", new Object[0]);
    }

    public Object[] send(String method, String signature, Object ... arguments) {
        return this.msg.send(this.serviceName, this.objectPath, this.interfaceName, method, signature, arguments);
    }

    protected Variant getProperty(String property) {
        return this.msg.getProperty(this.serviceName, this.objectPath, this.interfaceName, property);
    }

    protected Variant getAllProperties() {
        return this.msg.getAllProperties(this.serviceName, this.objectPath, this.interfaceName);
    }

    protected void setProperty(String property, Variant value) {
        this.msg.setProperty(this.serviceName, this.objectPath, this.interfaceName, property, value);
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getObjectPath() {
        return this.objectPath;
    }

    public ObjectPath getPath() {
        return Static.Convert.toObjectPath(this.objectPath);
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    public MessageHandler getMessageHandler() {
        return this.msg;
    }

    public SignalHandler getSignalHandler() {
        return this.sh;
    }

    public DBusConnection getConnection() {
        return this.connection;
    }
}

