/*
 * Decompiled with CFR 0.152.
 */
package org.purejava.kwallet.freedesktop.dbus.handlers;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.purejava.kwallet.KWallet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignalHandler
implements DBusSigHandler {
    private static SignalHandler instance = new SignalHandler();
    private static final Logger LOG = LoggerFactory.getLogger(SignalHandler.class);
    private PropertyChangeSupport support;
    private DBusConnection connection = null;
    private List<Class<? extends DBusSignal>> registered = new ArrayList<Class<? extends DBusSignal>>();
    private DBusSignal[] handled = new DBusSignal[250];
    private int count = 0;

    private SignalHandler() {
        this.support = new PropertyChangeSupport(this);
    }

    public static SignalHandler getInstance() {
        return instance;
    }

    public void addPropertyChangeListener(PropertyChangeListener pcl) {
        this.support.addPropertyChangeListener(pcl);
    }

    public void removePropertyChangeListener(PropertyChangeListener pcl) {
        this.support.removePropertyChangeListener(pcl);
    }

    public void connect(DBusConnection connection, List<Class<? extends DBusSignal>> signals) {
        if (null == this.connection) {
            this.connection = connection;
        }
        if (signals != null) {
            try {
                for (Class<? extends DBusSignal> sc : signals) {
                    if (this.registered.contains(sc)) continue;
                    connection.addSigHandler(sc, (DBusSigHandler)this);
                    this.registered.add(sc);
                }
            }
            catch (DBusException e) {
                LOG.error(e.toString(), e.getCause());
            }
        }
    }

    public void handle(DBusSignal s) {
        Collections.rotate(Arrays.asList(this.handled), 1);
        this.handled[0] = s;
        ++this.count;
        if (s instanceof KWallet.walletOpened) {
            KWallet.walletOpened wo = (KWallet.walletOpened)s;
            this.support.firePropertyChange("KWallet.walletOpened", null, wo.wallet);
            LOG.info("Received signal KWallet.walletOpened: {}", (Object)wo.wallet);
        } else if (s instanceof KWallet.walletAsyncOpened) {
            KWallet.walletAsyncOpened wo = (KWallet.walletAsyncOpened)s;
            this.support.firePropertyChange("KWallet.walletAsyncOpened", null, (Object)wo.handle);
            LOG.info("Received signal KWallet.walletAsyncOpened: {TransactionID: {}, handle: {}}", (Object)wo.tId, (Object)wo.handle);
        } else if (s instanceof KWallet.walletDeleted) {
            KWallet.walletDeleted wd = (KWallet.walletDeleted)s;
            this.support.firePropertyChange("KWallet.walletDeleted", null, wd.wallet);
            LOG.info("Received signal KWallet.walletDeleted: {}", (Object)wd.wallet);
        } else if (s instanceof KWallet.walletClosedId) {
            KWallet.walletClosedId wc = (KWallet.walletClosedId)s;
            this.support.firePropertyChange("KWallet.walletClosedId", null, (Object)wc.handle);
            LOG.info("Received signal KWallet.walletClosedId: {}", (Object)wc.handle);
        } else if (s instanceof KWallet.walletClosed) {
            KWallet.walletClosed wc = (KWallet.walletClosed)s;
            this.support.firePropertyChange("KWallet.walletClosed", null, wc.wallet);
            LOG.info("Received signal KWallet.walletClosed: {}", (Object)wc.wallet);
        } else if (s instanceof KWallet.allWalletsClosed) {
            this.support.firePropertyChange("KWallet.allWalletsClosed", null, s.getPath());
            LOG.info("Received signal KWallet.allWalletsClosed: {}", (Object)s.getPath());
        } else if (s instanceof KWallet.folderListUpdated) {
            KWallet.folderListUpdated flu = (KWallet.folderListUpdated)s;
            this.support.firePropertyChange("KWallet.folderListUpdated", null, flu.wallet);
            LOG.info("Received signal KWallet.folderListUpdated: {}", (Object)flu.wallet);
        } else if (s instanceof KWallet.folderUpdated) {
            KWallet.folderUpdated fu = (KWallet.folderUpdated)s;
            this.support.firePropertyChange("KWallet.folderUpdated", null, fu.a + "/" + fu.b);
            LOG.info("Received signal KWallet.folderUpdated: {wallet: {}, folder: {}}", (Object)fu.a, (Object)fu.b);
        } else if (s instanceof KWallet.applicationDisconnected) {
            KWallet.applicationDisconnected ad = (KWallet.applicationDisconnected)s;
            this.support.firePropertyChange("KWallet.applicationDisconnected", null, ad.application + "/" + ad.wallet);
            LOG.info("Received signal KWallet.applicationDisconnected: {application: {}, wallet: {}}", (Object)ad.application, (Object)ad.wallet);
        } else if (s instanceof KWallet.walletListDirty) {
            this.support.firePropertyChange("KWallet.walletListDirty", null, s.getPath());
            LOG.debug("Received signal KWallet.walletListDirty: {}", (Object)s.getPath());
        } else if (s instanceof KWallet.walletCreated) {
            KWallet.walletCreated wc = (KWallet.walletCreated)s;
            this.support.firePropertyChange("KWallet.walletCreated", null, wc.wallet);
            LOG.info("Received signal KWallet.walletCreated: {}", (Object)wc.wallet);
        } else {
            LOG.warn("Received unknown signal: {} {{}}", s.getClass(), (Object)s);
        }
    }

    public DBusSignal[] getHandledSignals() {
        return this.handled;
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s) {
        return Arrays.stream(this.handled).filter(Objects::nonNull).filter(signal -> signal.getClass().equals(s)).map(signal -> signal).collect(Collectors.toList());
    }

    public <S extends DBusSignal> List<S> getHandledSignals(Class<S> s, String path) {
        return Arrays.stream(this.handled).filter(Objects::nonNull).filter(signal -> signal.getClass().equals(s)).filter(signal -> signal.getPath().equals(path)).map(signal -> signal).collect(Collectors.toList());
    }

    public int getCount() {
        return this.count;
    }

    public DBusSignal getLastHandledSignal() {
        return this.handled.length > 0 ? this.handled[0] : null;
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s) {
        return (S)(this.getHandledSignals(s).isEmpty() ? null : (DBusSignal)this.getHandledSignals(s).get(0));
    }

    public <S extends DBusSignal> S getLastHandledSignal(Class<S> s, String path) {
        return (S)(this.getHandledSignals(s, path).isEmpty() ? null : (DBusSignal)this.getHandledSignals(s, path).get(0));
    }

    @Deprecated
    public <S extends DBusSignal> S await(Class<S> s, String path, Callable action) {
        Duration timeout = Duration.ofSeconds(120L);
        return this.await(s, path, action, timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <S extends DBusSignal> S await(Class<S> s, String path, Callable action, Duration timeout) {
        int init = this.getCount();
        try {
            action.call();
        }
        catch (Exception e) {
            LOG.error(e.toString(), e.getCause());
        }
        ExecutorService executor = Executors.newSingleThreadExecutor();
        LOG.info("Await signal {}({}) within {} seconds.", new Object[]{s.getName(), path, timeout.getSeconds()});
        Future<Object> handler = executor.submit(() -> {
            int await = init;
            List signals = null;
            while (await == init) {
                if (Thread.currentThread().isInterrupted()) {
                    return null;
                }
                Thread.currentThread();
                Thread.sleep(50L);
                signals = this.getHandledSignals(s, path);
                await = this.getCount();
            }
            if (!signals.isEmpty()) {
                return signals.get(0);
            }
            return null;
        });
        try {
            DBusSignal dBusSignal = (DBusSignal)handler.get(timeout.toMillis(), TimeUnit.MILLISECONDS);
            return (S)dBusSignal;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            handler.cancel(true);
            LOG.warn(e.toString(), e.getCause());
        }
        finally {
            executor.shutdownNow();
        }
        return null;
    }
}

