/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.integrations.common;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Documented
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=OperatingSystems.class)
public @interface OperatingSystem {
    public Value value() default Value.UNKNOWN;

    public static enum Value {
        LINUX,
        MAC,
        WINDOWS,
        UNKNOWN;

        private static final String OS_NAME;

        public static Value current() {
            if (OS_NAME.contains("linux")) {
                return LINUX;
            }
            if (OS_NAME.contains("mac")) {
                return MAC;
            }
            if (OS_NAME.contains("windows")) {
                return WINDOWS;
            }
            return UNKNOWN;
        }

        public static boolean isCurrent(OperatingSystem os) {
            return Value.current().equals((Object)os.value());
        }

        static {
            OS_NAME = System.getProperty("os.name", "").toLowerCase();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface OperatingSystems {
        public OperatingSystem[] value();
    }
}

